/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.items;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import tech.alexnijjar.golemoverhaul.common.entities.projectiles.HoneyBlobProjectile;

public class HoneyBlobItem
extends Item {
    public HoneyBlobItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SLIME_ATTACK, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            HoneyBlobProjectile projectile = new HoneyBlobProjectile(level, (LivingEntity)player);
            Vec3 lookAngle = player.getLookAngle();
            projectile.setPos(player.getX() + lookAngle.x, player.getEyeY() + lookAngle.y, player.getZ() + lookAngle.z);
            projectile.setBaseDamage(10.0);
            projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.25f, 2.0f);
            level.addFreshEntity((Entity)projectile);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }
}

