/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.projectiles;

import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModItems;
import tech.alexnijjar.golemoverhaul.common.tags.ModEntityTypeTags;

public class HoneyBlobProjectile
extends AbstractArrow
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HoneyBlobProjectile(EntityType<? extends AbstractArrow> type, Level level) {
        super(type, level);
    }

    public HoneyBlobProjectile(Level level, LivingEntity owner) {
        super((EntityType)ModEntityTypes.HONEY_BLOB.get(), level);
        this.setOwner((Entity)owner);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    private ParticleOptions getParticle() {
        return new ItemParticleOption(ParticleTypes.ITEM, Items.HONEY_BLOCK.getDefaultInstance());
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(this.getParticle(), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity livingEntity;
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            if (entity.getType().is(ModEntityTypeTags.HONEY_IMMUNE)) {
                livingEntity.heal(20.0f);
                return;
            }
        }
        if (this.getOwner() != null && entity.equals((Object)this.getOwner())) {
            return;
        }
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 6.0f);
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, this.getOwner() instanceof Player ? 180 : 60, 2));
        }
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.HONEY_BLOCK_BREAK;
    }

    protected ItemStack getDefaultPickupItem() {
        return ((Item)ModItems.HONEY_BLOB.get()).getDefaultInstance();
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            this.discard();
        }
    }
}

