/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.blocks;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantComponents;
import tech.alexnijjar.golemoverhaul.common.entities.golems.CandleGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class CandleGolemBlock
extends AbstractCandleBlock {
    public static final MapCodec<CandleGolemBlock> CODEC = CandleGolemBlock.simpleCodec(CandleGolemBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final Vec3 OFFSET = new Vec3(0.5, 0.5625, 0.5);
    public static final VoxelShape SHAPE_NORTH = Stream.of(Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)5.0, (double)10.5), Block.box((double)10.5, (double)0.0, (double)6.5, (double)11.5, (double)3.0, (double)9.5), Block.box((double)4.5, (double)0.0, (double)6.5, (double)5.5, (double)3.0, (double)9.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_EAST = Stream.of(Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)5.0, (double)10.5), Block.box((double)6.5, (double)0.0, (double)10.5, (double)9.5, (double)3.0, (double)11.5), Block.box((double)6.5, (double)0.0, (double)4.5, (double)9.5, (double)3.0, (double)5.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_SOUTH = Stream.of(Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)5.0, (double)10.5), Block.box((double)4.5, (double)0.0, (double)6.5, (double)5.5, (double)3.0, (double)9.5), Block.box((double)10.5, (double)0.0, (double)6.5, (double)11.5, (double)3.0, (double)9.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_WEST = Stream.of(Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)5.0, (double)10.5), Block.box((double)6.5, (double)0.0, (double)4.5, (double)9.5, (double)3.0, (double)5.5), Block.box((double)6.5, (double)0.0, (double)10.5, (double)9.5, (double)3.0, (double)11.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    protected MapCodec<? extends AbstractCandleBlock> codec() {
        return CODEC;
    }

    public CandleGolemBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT, WATERLOGGED});
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.isClientSide()) {
            return;
        }
        if (level.hasNeighborSignal(pos)) {
            this.spawnGolem(level, pos, state);
            level.destroyBlock(pos, false);
        }
    }

    protected Iterable<Vec3> getParticleOffsets(BlockState state) {
        return List.of(OFFSET);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean isFlintAndSteel;
        if (level.isClientSide()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!(((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() || ((Boolean)state.getValue((Property)LIT)).booleanValue() || stack.isEmpty() || !(isFlintAndSteel = stack.is(Items.FLINT_AND_STEEL)) && !stack.is(Items.FIRE_CHARGE))) {
            if (!level.isClientSide()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                level.playSound(null, pos, isFlintAndSteel ? SoundEvents.FLINTANDSTEEL_USE : SoundEvents.FIRECHARGE_USE, player.getSoundSource(), 1.0f, level.random.nextFloat() * 0.4f + 0.8f);
                if (isFlintAndSteel) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        this.spawnGolem(level, pos, state);
        level.destroyBlock(pos, false);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    private void spawnGolem(Level level, BlockPos pos, BlockState state) {
        CandleGolem golem = (CandleGolem)((EntityType)ModEntityTypes.CANDLE_GOLEM.get()).create(level);
        if (golem == null) {
            return;
        }
        golem.setLit((Boolean)level.getBlockState(pos).getValue((Property)LIT));
        golem.moveTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, ((Direction)state.getValue((Property)FACING)).toYRot(), 0.0f);
        level.addFreshEntity((Entity)golem);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType().equals(Fluids.WATER)));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add(ConstantComponents.CANDLE_GOLEM_TOOLTIP);
    }
}

