/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.renderers.entities.golems;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemModel;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.utils.ModRenderTypes;
import tech.alexnijjar.golemoverhaul.common.entities.golems.CoalGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class CoalGolemRenderer
extends BaseGolemRenderer<CoalGolem> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"textures/entity/coal/coal_golem.png");
    public static final ResourceLocation LIT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"textures/entity/coal/coal_golem_lit.png");

    public CoalGolemRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new BaseGolemModel<CoalGolem>(ModEntityTypes.COAL_GOLEM, false, 0));
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer<CoalGolem>(this, (GeoRenderer)this){

            protected RenderType getRenderType(CoalGolem golem, @Nullable MultiBufferSource bufferSource) {
                return golem.isLit() ? ModRenderTypes.eyesNoCull(LIT_TEXTURE) : RenderType.entityCutout((ResourceLocation)TEXTURE);
            }
        });
    }

    public ResourceLocation getTextureLocation(CoalGolem golem) {
        return golem.isLit() ? LIT_TEXTURE : TEXTURE;
    }

    protected void applyRotations(CoalGolem golem, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        int deathTime = golem.deathTime;
        golem.deathTime = 0;
        super.applyRotations((Entity)golem, poseStack, ageInTicks, rotationYaw, partialTick, nativeScale);
        golem.deathTime = deathTime;
    }
}

