/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.neoforge.RenderUtilsImpl;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class RenderUtils {
    public static boolean vanillaModel(Avatar avatar) {
        return avatar != null && avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) >= 1;
    }

    public static boolean vanillaModelAndScript(Avatar avatar) {
        return avatar != null && avatar.luaRuntime != null && avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) >= 1;
    }

    public static TextureAtlasSprite firstFireLayer(Avatar avatar) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        ResourceLocation layer = avatar.luaRuntime.renderer.fireLayer1;
        return layer != null ? (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(layer) : null;
    }

    public static TextureAtlasSprite secondFireLayer(Avatar avatar) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        ResourceLocation layer1 = avatar.luaRuntime.renderer.fireLayer1;
        ResourceLocation layer2 = avatar.luaRuntime.renderer.fireLayer2;
        if (layer2 != null) {
            return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(layer2);
        }
        if (layer1 != null) {
            return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(layer1);
        }
        return null;
    }

    public static VanillaPart partFromSlot(Avatar avatar, EquipmentSlot equipmentSlot) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        return switch (equipmentSlot) {
            case EquipmentSlot.HEAD -> avatar.luaRuntime.vanilla_model.HELMET;
            case EquipmentSlot.CHEST -> avatar.luaRuntime.vanilla_model.CHESTPLATE;
            case EquipmentSlot.LEGS -> avatar.luaRuntime.vanilla_model.LEGGINGS;
            case EquipmentSlot.FEET -> avatar.luaRuntime.vanilla_model.BOOTS;
            default -> null;
        };
    }

    public static VanillaPart pivotToPart(Avatar avatar, ParentType type) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        return switch (type) {
            case ParentType.HelmetPivot -> avatar.luaRuntime.vanilla_model.HELMET;
            case ParentType.ChestplatePivot -> avatar.luaRuntime.vanilla_model.CHESTPLATE;
            case ParentType.LeftShoulderPivot -> avatar.luaRuntime.vanilla_model.CHESTPLATE_LEFT_ARM;
            case ParentType.RightShoulderPivot -> avatar.luaRuntime.vanilla_model.CHESTPLATE_RIGHT_ARM;
            case ParentType.LeggingsPivot -> avatar.luaRuntime.vanilla_model.LEGGINGS;
            case ParentType.LeftLeggingPivot -> avatar.luaRuntime.vanilla_model.LEGGINGS_LEFT_LEG;
            case ParentType.RightLeggingPivot -> avatar.luaRuntime.vanilla_model.LEGGINGS_RIGHT_LEG;
            case ParentType.LeftBootPivot -> avatar.luaRuntime.vanilla_model.BOOTS_LEFT_LEG;
            case ParentType.RightBootPivot -> avatar.luaRuntime.vanilla_model.BOOTS_RIGHT_LEG;
            case ParentType.LeftElytraPivot -> avatar.luaRuntime.vanilla_model.LEFT_ELYTRA;
            case ParentType.RightElytraPivot -> avatar.luaRuntime.vanilla_model.RIGHT_ELYTRA;
            default -> null;
        };
    }

    public static EquipmentSlot slotFromPart(ParentType type) {
        switch (type) {
            case HelmetPivot: 
            case Head: 
            case HelmetItemPivot: 
            case Skull: {
                return EquipmentSlot.HEAD;
            }
            case ChestplatePivot: 
            case LeftShoulderPivot: 
            case RightShoulderPivot: 
            case LeftElytraPivot: 
            case RightElytraPivot: 
            case Body: 
            case LeftElytra: 
            case RightElytra: {
                return EquipmentSlot.CHEST;
            }
            case LeftArm: 
            case LeftItemPivot: 
            case LeftSpyglassPivot: {
                return EquipmentSlot.OFFHAND;
            }
            case RightArm: 
            case RightItemPivot: 
            case RightSpyglassPivot: {
                return EquipmentSlot.MAINHAND;
            }
            case LeggingsPivot: 
            case LeftLeggingPivot: 
            case RightLeggingPivot: 
            case LeftLeg: 
            case RightLeg: {
                return EquipmentSlot.LEGS;
            }
            case LeftBootPivot: 
            case RightBootPivot: {
                return EquipmentSlot.FEET;
            }
        }
        return null;
    }

    public static boolean renderArmItem(Avatar avatar, boolean lefty, CallbackInfo ci) {
        if (!RenderUtils.vanillaModel(avatar)) {
            return false;
        }
        if (avatar.luaRuntime != null && (lefty && !avatar.luaRuntime.vanilla_model.LEFT_ITEM.checkVisible() || !lefty && !avatar.luaRuntime.vanilla_model.RIGHT_ITEM.checkVisible())) {
            ci.cancel();
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>> ResourceLocation getArmorResource(Entity entity, ItemStack stack, ArmorItem item, EquipmentSlot slot, boolean isInner, ArmorMaterial.Layer armormaterial$layer) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return RenderUtilsImpl.getArmorResource(entity, (ItemStack)var1_1, (ArmorItem)var2_2, (EquipmentSlot)var3_3, (boolean)var4_4, (ArmorMaterial.Layer)var5_5);
    }
}

