/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import java.nio.file.Path;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;

public class PathUtils {
    public static Path getPath(String path) {
        if (((String)path).isEmpty()) {
            return Path.of("/", new String[0]);
        }
        if (!((String)path).startsWith(".")) {
            path = "/" + (String)path;
        }
        return Path.of(((String)path).replaceAll("\\\\", "/").replaceAll("[\\.]([^\\./])", "/$1").replaceAll("\\/\\/", "/"), new String[0]);
    }

    public static Path getPath(LuaValue path) {
        String str = path.isnil() ? "/" : path.checkjstring();
        return PathUtils.getPath(str);
    }

    public static Path getWorkingDirectory(LuaFunction debugGetinfo) {
        LuaValue stack;
        int i = 1;
        String file = "";
        while (!(stack = debugGetinfo.call((LuaValue)LuaValue.valueOf((int)i++))).isnil() && (file = stack.get("source").checkjstring()).equals("=[Java]")) {
        }
        Path path = Path.of("/" + file, new String[0]);
        return path.getNameCount() > 1 ? path.resolve("../").normalize() : Path.of("/", new String[0]);
    }

    public static String computeSafeString(Path path) {
        String str = path == null ? "" : path.normalize().toString();
        return str.replaceAll("\\\\", "/").replaceAll("^\\/+", "");
    }

    public static String computeSafeString(String path) {
        return PathUtils.computeSafeString(PathUtils.getPath(path));
    }

    public static boolean isAbsolute(Path path) {
        return path.getRoot() != null || !path.toString().startsWith(".");
    }

    public static boolean isAbsolute(String path) {
        return PathUtils.isAbsolute(PathUtils.getPath(path));
    }
}

