/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.figuramc.figura.mixin.ClientLevelInvoker;
import org.figuramc.figura.mixin.EntityAccessor;
import org.figuramc.figura.mixin.gui.PlayerTabOverlayAccessor;

public class EntityUtils {
    public static Entity getEntityByUUID(UUID uuid) {
        if (Minecraft.getInstance().level == null) {
            return null;
        }
        return (Entity)((ClientLevelInvoker)Minecraft.getInstance().level).getEntityGetter().get(uuid);
    }

    public static Entity getViewedEntity(float distance) {
        BlockHitResult blockResult;
        double raycastDistanceSquared;
        Entity entity = Minecraft.getInstance().getCameraEntity();
        if (entity == null) {
            return null;
        }
        float tickDelta = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        Vec3 entityEye = entity.getEyePosition(tickDelta);
        Vec3 viewVec = entity.getViewVector(tickDelta).scale((double)distance);
        AABB box = entity.getBoundingBox().expandTowards(viewVec).inflate(1.0, 1.0, 1.0);
        Vec3 raycastEnd = entityEye.add(viewVec);
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)entityEye, (Vec3)raycastEnd, (AABB)box, entity1 -> !entity1.isSpectator() && entity1.isPickable(), (double)(raycastDistanceSquared = (blockResult = ((EntityAccessor)entity).getLevel().clip(new ClipContext(entityEye, raycastEnd, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, entity))) != null ? blockResult.getLocation().distanceToSqr(entityEye) : (double)(distance * distance)));
        if (entityHitResult != null) {
            return entityHitResult.getEntity();
        }
        return null;
    }

    public static PlayerInfo getPlayerInfo(UUID uuid) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        return connection == null ? null : connection.getPlayerInfo(uuid);
    }

    public static String getNameForUUID(UUID uuid) {
        PlayerInfo player = EntityUtils.getPlayerInfo(uuid);
        if (player != null) {
            return player.getProfile().getName();
        }
        Entity e = EntityUtils.getEntityByUUID(uuid);
        if (e != null) {
            return e.getName().getString();
        }
        return null;
    }

    public static Map<String, UUID> getPlayerList() {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection == null || connection.getOnlinePlayerIds().isEmpty()) {
            return Map.of();
        }
        HashMap<String, UUID> playerList = new HashMap<String, UUID>();
        for (UUID uuid : connection.getOnlinePlayerIds()) {
            PlayerInfo player = connection.getPlayerInfo(uuid);
            if (player == null) continue;
            playerList.put(player.getProfile().getName(), uuid);
        }
        return playerList;
    }

    public static List<PlayerInfo> getTabList() {
        return ((PlayerTabOverlayAccessor)Minecraft.getInstance().gui.getTabList()).getThePlayerInfos();
    }

    public static boolean checkInvalidPlayer(UUID id) {
        if (id.version() != 4) {
            return true;
        }
        PlayerInfo playerInfo = EntityUtils.getPlayerInfo(id);
        if (playerInfo == null) {
            return false;
        }
        GameProfile profile = playerInfo.getProfile();
        String name = profile.getName();
        return name != null && (name.isBlank() || name.charAt(0) == '\u0000');
    }
}

