/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.animation.Animation;
import org.figuramc.figura.animation.Interpolation;
import org.figuramc.figura.animation.Keyframe;
import org.figuramc.figura.animation.TransformType;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.model.FiguraModelPart;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.model.PartCustomization;
import org.figuramc.figura.model.rendering.Vertex;
import org.figuramc.figura.model.rendering.texture.FiguraTextureSet;
import org.figuramc.figura.model.rendering.texture.RenderTypes;
import org.figuramc.figura.utils.MathUtils;

public class FiguraModelPartReader {
    private static final Map<String, FiguraVec3[]> faceData = ImmutableMap.of((Object)"n", (Object)new FiguraVec3[]{FiguraVec3.of(1.0, 0.0, 0.0), FiguraVec3.of(0.0, 0.0, 0.0), FiguraVec3.of(0.0, 1.0, 0.0), FiguraVec3.of(1.0, 1.0, 0.0), FiguraVec3.of(0.0, 0.0, -1.0)}, (Object)"s", (Object)new FiguraVec3[]{FiguraVec3.of(0.0, 0.0, 1.0), FiguraVec3.of(1.0, 0.0, 1.0), FiguraVec3.of(1.0, 1.0, 1.0), FiguraVec3.of(0.0, 1.0, 1.0), FiguraVec3.of(0.0, 0.0, 1.0)}, (Object)"e", (Object)new FiguraVec3[]{FiguraVec3.of(1.0, 0.0, 1.0), FiguraVec3.of(1.0, 0.0, 0.0), FiguraVec3.of(1.0, 1.0, 0.0), FiguraVec3.of(1.0, 1.0, 1.0), FiguraVec3.of(1.0, 0.0, 0.0)}, (Object)"w", (Object)new FiguraVec3[]{FiguraVec3.of(0.0, 0.0, 0.0), FiguraVec3.of(0.0, 0.0, 1.0), FiguraVec3.of(0.0, 1.0, 1.0), FiguraVec3.of(0.0, 1.0, 0.0), FiguraVec3.of(-1.0, 0.0, 0.0)}, (Object)"u", (Object)new FiguraVec3[]{FiguraVec3.of(0.0, 1.0, 1.0), FiguraVec3.of(1.0, 1.0, 1.0), FiguraVec3.of(1.0, 1.0, 0.0), FiguraVec3.of(0.0, 1.0, 0.0), FiguraVec3.of(0.0, 1.0, 0.0)}, (Object)"d", (Object)new FiguraVec3[]{FiguraVec3.of(0.0, 0.0, 0.0), FiguraVec3.of(1.0, 0.0, 0.0), FiguraVec3.of(1.0, 0.0, 1.0), FiguraVec3.of(0.0, 0.0, 1.0), FiguraVec3.of(0.0, -1.0, 0.0)});
    private static final FiguraVec2[] uvValues = new FiguraVec2[]{FiguraVec2.of(0.0, 1.0), FiguraVec2.of(1.0, 1.0), FiguraVec2.of(1.0, 0.0), FiguraVec2.of(0.0, 0.0)};

    public static FiguraModelPart read(Avatar owner, CompoundTag partCompound, List<FiguraTextureSet> textureSets, boolean smoothNormals) {
        String name = partCompound.getString("name");
        PartCustomization customization = new PartCustomization();
        customization.needsMatrixRecalculation = true;
        FiguraVec3 rot = FiguraVec3.of();
        FiguraModelPartReader.readVec3(rot, partCompound, "rot");
        customization.setRot(rot);
        FiguraVec3 piv = FiguraVec3.of();
        FiguraModelPartReader.readVec3(piv, partCompound, "piv");
        customization.setPivot(piv);
        if (partCompound.contains("primary")) {
            try {
                customization.setPrimaryRenderType(RenderTypes.valueOf(partCompound.getString("primary")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (partCompound.contains("secondary")) {
            try {
                customization.setSecondaryRenderType(RenderTypes.valueOf(partCompound.getString("secondary")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (partCompound.contains("vsb")) {
            customization.visible = partCompound.getBoolean("vsb");
        }
        ArrayList<Integer> facesByTexture = new ArrayList<Integer>(0);
        while (textureSets.size() > facesByTexture.size()) {
            facesByTexture.add(0);
        }
        HashMap<Integer, List<Vertex>> vertices = new HashMap<Integer, List<Vertex>>();
        if (FiguraModelPartReader.hasCubeData(partCompound)) {
            FiguraModelPartReader.readCuboid(facesByTexture, partCompound, vertices);
            customization.partType = PartCustomization.PartType.CUBE;
        } else if (FiguraModelPartReader.hasMeshData(partCompound)) {
            FiguraModelPartReader.readMesh(facesByTexture, partCompound, vertices);
            customization.partType = PartCustomization.PartType.MESH;
        }
        if (partCompound.contains("smo")) {
            smoothNormals = partCompound.getBoolean("smo");
        }
        if (((Boolean)Configs.FORCE_SMOOTH_AVATAR.value).booleanValue() || smoothNormals && !vertices.isEmpty()) {
            FiguraModelPartReader.smoothfy(vertices);
        }
        ArrayList<FiguraModelPart> children = new ArrayList<FiguraModelPart>(0);
        if (partCompound.contains("chld")) {
            ListTag listTag = partCompound.getList("chld", 10);
            for (Tag tag : listTag) {
                children.add(FiguraModelPartReader.read(owner, (CompoundTag)tag, textureSets, smoothNormals));
            }
        }
        FiguraModelPart result = new FiguraModelPart(owner, name, customization, vertices, children);
        for (FiguraModelPart child : children) {
            child.parent = result;
        }
        result.facesByTexture = facesByTexture;
        FiguraModelPartReader.storeTextures(result, textureSets);
        if (partCompound.contains("pt")) {
            try {
                result.parentType = ParentType.valueOf(partCompound.getString("pt"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (partCompound.contains("anim")) {
            ListTag nbt = partCompound.getList("anim", 10);
            for (Tag tag : nbt) {
                Animation animation;
                CompoundTag compound = (CompoundTag)tag;
                if (!compound.contains("id") || !compound.contains("data") || (animation = owner.animations.get(compound.getInt("id"))) == null) continue;
                CompoundTag animNbt = compound.getCompound("data");
                Iterator iterator = animNbt.getAllKeys().iterator();
                while (iterator.hasNext()) {
                    TransformType type;
                    String channelString;
                    switch (channelString = (String)iterator.next()) {
                        case "pos": {
                            TransformType transformType = TransformType.POSITION;
                            break;
                        }
                        case "rot": {
                            TransformType transformType = TransformType.ROTATION;
                            break;
                        }
                        case "grot": {
                            TransformType transformType = TransformType.GLOBAL_ROT;
                            break;
                        }
                        case "scl": {
                            TransformType transformType = TransformType.SCALE;
                            break;
                        }
                        default: {
                            TransformType transformType = type = null;
                        }
                    }
                    if (type == null) continue;
                    ArrayList<Keyframe> keyframes = new ArrayList<Keyframe>();
                    ListTag keyframeList = animNbt.getList(channelString, 10);
                    for (Tag keyframeTag : keyframeList) {
                        Pair end;
                        Interpolation interpolation;
                        CompoundTag keyframeNbt = (CompoundTag)keyframeTag;
                        float time = keyframeNbt.getFloat("time");
                        try {
                            interpolation = Interpolation.valueOf(keyframeNbt.getString("int").toUpperCase(Locale.US));
                        }
                        catch (Exception e) {
                            FiguraMod.LOGGER.error("Invalid interpolation type in the model {}, something is wrong with this model!", (Object)keyframeNbt.getString("int"));
                            FiguraMod.LOGGER.error("", (Throwable)e);
                            continue;
                        }
                        Pair pre = FiguraModelPartReader.parseKeyframeData(keyframeNbt, "pre");
                        if (pre == null) {
                            pre = Pair.of((Object)FiguraVec3.of(), null);
                        }
                        if ((end = FiguraModelPartReader.parseKeyframeData(keyframeNbt, "end")) == null) {
                            end = pre;
                        }
                        FiguraVec3 bezierLeft = FiguraVec3.of();
                        FiguraVec3 bezierRight = FiguraVec3.of();
                        FiguraModelPartReader.readVec3(bezierLeft, keyframeNbt, "bl");
                        FiguraModelPartReader.readVec3(bezierRight, keyframeNbt, "br");
                        FiguraVec3 bezierLeftTime = FiguraVec3.of(-0.1, -0.1, -0.1);
                        FiguraVec3 bezierRightTime = FiguraVec3.of(0.1, 0.1, 0.1);
                        FiguraModelPartReader.readVec3(bezierLeftTime, keyframeNbt, "blt");
                        FiguraModelPartReader.readVec3(bezierRightTime, keyframeNbt, "brt");
                        bezierLeftTime.add(1.0, 1.0, 1.0);
                        bezierLeftTime = MathUtils.clamp(bezierLeftTime, 0.0, 1.0);
                        bezierRightTime = MathUtils.clamp(bezierRightTime, 0.0, 1.0);
                        keyframes.add(new Keyframe(owner, animation, time, interpolation, (Pair<FiguraVec3, String[]>)pre, (Pair<FiguraVec3, String[]>)end, bezierLeft, bezierRight, bezierLeftTime, bezierRightTime));
                    }
                    keyframes.sort(Keyframe::compareTo);
                    animation.addAnimation(result, new Animation.AnimationChannel(type, keyframes.toArray(new Keyframe[0])));
                }
            }
        }
        return result;
    }

    private static Pair<FiguraVec3, String[]> parseKeyframeData(CompoundTag keyframeNbt, String tag) {
        if (!keyframeNbt.contains(tag)) {
            return null;
        }
        ListTag floatList = keyframeNbt.getList(tag, 5);
        if (!floatList.isEmpty()) {
            FiguraVec3 ret = FiguraVec3.of();
            FiguraModelPartReader.readVec3(ret, floatList);
            return Pair.of((Object)ret, null);
        }
        ListTag stringList = keyframeNbt.getList(tag, 8);
        return Pair.of(null, (Object)new String[]{stringList.getString(0), stringList.getString(1), stringList.getString(2)});
    }

    private static void storeTextures(FiguraModelPart modelPart, List<FiguraTextureSet> textureSets) {
        ArrayList<FiguraTextureSet> list = new ArrayList<FiguraTextureSet>(0);
        for (int j = 0; j < modelPart.facesByTexture.size(); ++j) {
            list.add(textureSets.get(j));
        }
        modelPart.textures = list;
        int w = -1;
        int h = -1;
        for (FiguraModelPart child : modelPart.children) {
            if (child.textureWidth == -1) {
                modelPart.textureWidth = -1;
                modelPart.textureHeight = -1;
                return;
            }
            if (child.textureWidth == w && child.textureHeight == h) continue;
            if (w != -1) {
                modelPart.textureWidth = -1;
                modelPart.textureHeight = -1;
                return;
            }
            w = child.textureWidth;
            h = child.textureHeight;
        }
        if (modelPart.customization.partType != PartCustomization.PartType.GROUP) {
            int i = -1;
            for (int j = 0; j < modelPart.facesByTexture.size(); ++j) {
                if (modelPart.facesByTexture.get(j) <= 0) continue;
                int realTexWidth = textureSets.get(j).getWidth();
                int realTexHeight = textureSets.get(j).getHeight();
                if (w != -1 && w != realTexWidth || h != -1 && h != realTexHeight) {
                    modelPart.textureWidth = -1;
                    modelPart.textureHeight = -1;
                    return;
                }
                if (i != -1) {
                    modelPart.textureWidth = -1;
                    modelPart.textureHeight = -1;
                    return;
                }
                i = j;
                w = realTexWidth;
                h = realTexHeight;
            }
        }
        modelPart.textureWidth = w;
        modelPart.textureHeight = h;
    }

    private static void readVec3(FiguraVec3 target, CompoundTag tag, String name) {
        if (tag.contains(name)) {
            FiguraModelPartReader.readVec3(target, (ListTag)tag.get(name));
        }
    }

    private static void readVec3(FiguraVec3 target, ListTag list) {
        switch (list.getElementType()) {
            case 5: {
                target.set(list.getFloat(0), (double)list.getFloat(1), (double)list.getFloat(2));
                break;
            }
            case 3: {
                target.set(list.getInt(0), (double)list.getInt(1), (double)list.getInt(2));
                break;
            }
            case 2: {
                target.set(list.getShort(0), (double)list.getShort(1), (double)list.getShort(2));
                break;
            }
            case 1: {
                target.set(((ByteTag)list.get(0)).getAsByte(), (double)((ByteTag)list.get(1)).getAsByte(), (double)((ByteTag)list.get(2)).getAsByte());
            }
        }
    }

    private static void readVec4(FiguraVec4 target, CompoundTag tag, String name) {
        if (tag.contains(name)) {
            ListTag list = (ListTag)tag.get(name);
            switch (list.getElementType()) {
                case 5: {
                    target.set(list.getFloat(0), (double)list.getFloat(1), (double)list.getFloat(2), (double)list.getFloat(3));
                    break;
                }
                case 3: {
                    target.set(list.getInt(0), (double)list.getInt(1), (double)list.getInt(2), (double)list.getInt(3));
                    break;
                }
                case 2: {
                    target.set(list.getShort(0), (double)list.getShort(1), (double)list.getShort(2), (double)list.getShort(3));
                    break;
                }
                case 1: {
                    target.set(((ByteTag)list.get(0)).getAsByte(), (double)((ByteTag)list.get(1)).getAsByte(), (double)((ByteTag)list.get(2)).getAsByte(), (double)((ByteTag)list.get(3)).getAsByte());
                }
            }
        } else {
            target.set(0.0, 0.0, 0.0, 0.0);
        }
    }

    private static boolean hasCubeData(CompoundTag partCompound) {
        if (partCompound.contains("cube_data", 10)) {
            return !partCompound.getCompound("cube_data").isEmpty();
        }
        return false;
    }

    private static boolean hasMeshData(CompoundTag partCompound) {
        if (partCompound.contains("mesh_data", 10)) {
            return !partCompound.getCompound("mesh_data").isEmpty();
        }
        return false;
    }

    private static void readCuboid(List<Integer> facesByTexture, CompoundTag data, Map<Integer, List<Vertex>> vertices) {
        FiguraVec3 from = FiguraVec3.of();
        FiguraModelPartReader.readVec3(from, data, "f");
        FiguraVec3 to = FiguraVec3.of();
        FiguraModelPartReader.readVec3(to, data, "t");
        double inflate = 0.0;
        if (data.contains("inf")) {
            inflate = data.getFloat("inf");
        }
        from.add(-inflate, -inflate, -inflate);
        to.add(inflate, inflate, inflate);
        FiguraVec3 ftDiff = to.copy();
        ftDiff.subtract(from);
        for (String direction : faceData.keySet()) {
            FiguraModelPartReader.readFace(data.getCompound("cube_data"), facesByTexture, direction, vertices, from, ftDiff);
        }
    }

    private static void readFace(CompoundTag faces, List<Integer> facesByTexture, String direction, Map<Integer, List<Vertex>> vertices, FiguraVec3 from, FiguraVec3 ftDiff) {
        if (faces.contains(direction)) {
            CompoundTag face = faces.getCompound(direction);
            short texId = face.getShort("tex");
            facesByTexture.set(texId, facesByTexture.get(texId) + 1);
            FiguraVec3 normal = faceData.get(direction)[4];
            int rotation = (int)(face.getFloat("rot") / 90.0f);
            FiguraVec4 uv = FiguraVec4.of();
            FiguraModelPartReader.readVec4(uv, face, "uv");
            for (int i = 0; i < 4; ++i) {
                FiguraVec3 tempPos = ftDiff.copy();
                tempPos.multiply(faceData.get(direction)[i]);
                tempPos.add(from);
                FiguraVec2 normalizedUv = uvValues[(i + rotation) % 4];
                List list = vertices.getOrDefault(texId, new ArrayList());
                list.add(new Vertex((float)tempPos.x, (float)tempPos.y, (float)tempPos.z, (float)Mth.lerp((double)normalizedUv.x, (double)uv.x, (double)uv.z), (float)Mth.lerp((double)normalizedUv.y, (double)uv.y, (double)uv.w), (float)normal.x, (float)normal.y, (float)normal.z));
                vertices.put(Integer.valueOf(texId), list);
            }
        }
    }

    private static void readMesh(List<Integer> facesByTexture, CompoundTag data, Map<Integer, List<Vertex>> vertices) {
        CompoundTag meshData = data.getCompound("mesh_data");
        ListTag verts = meshData.getList("vtx", 5);
        ListTag uvs = meshData.getList("uvs", 5);
        ListTag tex = meshData.getList("tex", 2);
        int bestType = 0;
        if (verts.size() > 765) {
            bestType = 1;
        }
        if (verts.size() > 98301) {
            bestType = 2;
        }
        ListTag fac = switch (bestType) {
            case 0 -> meshData.getList("fac", 1);
            case 1 -> meshData.getList("fac", 2);
            default -> meshData.getList("fac", 3);
        };
        int vi = 0;
        int uvi = 0;
        float[] posArr = new float[12];
        float[] uvArr = new float[8];
        for (int ti = 0; ti < tex.size(); ++ti) {
            short packed = tex.getShort(ti);
            int texId = packed >> 4;
            int numVerts = packed & 0xF;
            facesByTexture.set(texId, facesByTexture.get(texId) + 1);
            for (int j = 0; j < numVerts; ++j) {
                int vid = switch (bestType) {
                    case 0 -> ((ByteTag)fac.get(vi + j)).getAsByte() & 0xFF;
                    case 1 -> fac.getShort(vi + j) & 0xFFFF;
                    default -> fac.getInt(vi + j);
                };
                posArr[3 * j] = verts.getFloat(3 * vid);
                posArr[3 * j + 1] = verts.getFloat(3 * vid + 1);
                posArr[3 * j + 2] = verts.getFloat(3 * vid + 2);
                uvArr[2 * j] = uvs.getFloat(uvi + 2 * j);
                uvArr[2 * j + 1] = uvs.getFloat(uvi + 2 * j + 1);
            }
            FiguraVec3 p1 = FiguraVec3.of(posArr[0], posArr[1], posArr[2]);
            FiguraVec3 p2 = FiguraVec3.of(posArr[3], posArr[4], posArr[5]);
            FiguraVec3 p3 = FiguraVec3.of(posArr[6], posArr[7], posArr[8]);
            p3.subtract(p2);
            p1.subtract(p2);
            p3.cross(p1);
            p3.normalize();
            for (int j = 0; j < numVerts; ++j) {
                List list = vertices.getOrDefault(texId, new ArrayList());
                list.add(new Vertex(posArr[3 * j], posArr[3 * j + 1], posArr[3 * j + 2], uvArr[2 * j], uvArr[2 * j + 1], (float)p3.x, (float)p3.y, (float)p3.z));
                vertices.put(texId, list);
            }
            if (numVerts == 3) {
                List list = vertices.getOrDefault(texId, new ArrayList());
                list.add(new Vertex(posArr[6], posArr[7], posArr[8], uvArr[4], uvArr[5], (float)p3.x, (float)p3.y, (float)p3.z));
                vertices.put(texId, list);
            }
            vi += numVerts;
            uvi += 2 * numVerts;
        }
    }

    private static void smoothfy(Map<Integer, List<Vertex>> verticesByTextuers) {
        HashMap<String, List> verticesByPos = new HashMap<String, List>();
        for (List<Vertex> vertices : verticesByTextuers.values()) {
            for (Vertex vertex : vertices) {
                String id = String.valueOf(vertex.getPos());
                List list = verticesByPos.computeIfAbsent(id, str -> new ArrayList(4));
                list.add(vertex);
            }
        }
        for (List<Vertex> vertices : verticesByPos.values()) {
            FiguraVec3 result = FiguraVec3.of();
            for (Vertex vertex : vertices) {
                result.add(vertex.getNormal());
            }
            result.normalize();
            for (Vertex vertex : vertices) {
                vertex.setNormal(result);
            }
        }
    }
}

