/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.ducks.PlayerModelAccessor;
import org.figuramc.figura.lua.api.vanilla_model.VanillaGroupPart;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.RenderUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CapeLayer.class})
public abstract class CapeLayerMixin
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    @Unique
    private Avatar avatar;

    public CapeLayerMixin(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent) {
        super(renderLayerParent);
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;FFFFFF)V"}, at={@At(value="HEAD")})
    private void preRender(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo ci) {
        ItemStack itemStack = entity.getItemBySlot(EquipmentSlot.CHEST);
        if (entity.isInvisible() || itemStack.is(Items.ELYTRA)) {
            return;
        }
        this.avatar = AvatarManager.getAvatar((Entity)entity);
        if (this.avatar == null) {
            return;
        }
        ModelPart fakeCloak = ((PlayerModelAccessor)this.getParentModel()).figura$getFakeCloak();
        ModelPart realCloak = ((PlayerModelAccessor)this.getParentModel()).figura$getCloak();
        fakeCloak.copyFrom(realCloak);
        double d = Mth.lerp((double)tickDelta, (double)entity.xCloakO, (double)entity.xCloak) - Mth.lerp((double)tickDelta, (double)entity.xo, (double)entity.getX());
        double e = Mth.lerp((double)tickDelta, (double)entity.yCloakO, (double)entity.yCloak) - Mth.lerp((double)tickDelta, (double)entity.yo, (double)entity.getY());
        double m = Mth.lerp((double)tickDelta, (double)entity.zCloakO, (double)entity.zCloak) - Mth.lerp((double)tickDelta, (double)entity.zo, (double)entity.getZ());
        float n = Mth.rotLerp((float)tickDelta, (float)entity.yBodyRotO, (float)entity.yBodyRot);
        n = (float)Math.toRadians(n);
        double o = Mth.sin((float)n);
        double p = -Mth.cos((float)n);
        float q = (float)e * 10.0f;
        q = Mth.clamp((float)q, (float)-6.0f, (float)32.0f);
        float r = (float)(d * o + m * p) * 100.0f;
        r = Mth.clamp((float)r, (float)0.0f, (float)150.0f);
        float s = (float)(d * p - m * o) * 100.0f;
        s = Mth.clamp((float)s, (float)-20.0f, (float)20.0f);
        r = Math.max(r, 0.0f);
        float t = Mth.lerp((float)tickDelta, (float)entity.oBob, (float)entity.bob);
        q += Mth.sin((float)(Mth.lerp((float)tickDelta, (float)entity.walkDistO, (float)entity.walkDist) * 6.0f)) * 32.0f * t;
        if (itemStack.isEmpty() || this.avatar.luaRuntime != null && !this.avatar.luaRuntime.vanilla_model.CHESTPLATE_BODY.checkVisible()) {
            if (entity.isCrouching()) {
                q += 25.0f;
                fakeCloak.y = 2.25f;
                fakeCloak.z = -0.25f;
            } else {
                fakeCloak.y = 0.0f;
                fakeCloak.z = 0.0f;
            }
        } else if (entity.isCrouching()) {
            q += 25.0f;
            fakeCloak.y = 0.85f;
            fakeCloak.z = 0.15f;
        } else {
            fakeCloak.y = -1.0f;
            fakeCloak.z = 1.0f;
        }
        fakeCloak.setRotation((float)Math.toRadians(6.0f + r / 2.0f + q), (float)(-Math.toRadians(s / 2.0f)), (float)Math.toRadians(s / 2.0f));
        if (this.avatar.luaRuntime != null) {
            VanillaGroupPart part = this.avatar.luaRuntime.vanilla_model.CAPE;
            EntityModel model = this.getParentModel();
            ((VanillaPart)part).save(model);
            if (this.avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
                ((VanillaPart)part).preTransform(model);
            }
        }
        this.avatar.capeRender((Entity)entity, multiBufferSource, poseStack, light, tickDelta, fakeCloak);
        if (RenderUtils.vanillaModelAndScript(this.avatar)) {
            this.avatar.luaRuntime.vanilla_model.CAPE.posTransform(this.getParentModel());
        }
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;FFFFFF)V"}, at={@At(value="RETURN")})
    private void postRender(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer abstractClientPlayer, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        if (this.avatar == null) {
            return;
        }
        if (this.avatar.luaRuntime != null) {
            this.avatar.luaRuntime.vanilla_model.CAPE.restore(this.getParentModel());
        }
        this.avatar = null;
    }
}

