/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.math.matrix.FiguraMat3;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.mixin.render.PoseStackAccessor;
import org.figuramc.figura.model.rendering.EntityRenderMode;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.RenderUtils;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Final
    private EntityRenderDispatcher entityRenderDispatcher;
    @Shadow
    @Final
    private RenderBuffers renderBuffers;
    @Shadow
    @Final
    private Minecraft minecraft;

    @ModifyArg(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"))
    private Entity renderLevelRenderEntity(Entity entity) {
        Avatar avatar = AvatarManager.getAvatar(entity);
        if (avatar != null) {
            avatar.renderMode = EntityRenderMode.RENDER;
        }
        return entity;
    }

    @Inject(method={"renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"}, at={@At(value="HEAD")})
    private void renderEntity(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource bufferSource, CallbackInfo ci) {
        Avatar avatar = AvatarManager.getAvatar(entity);
        if (avatar == null) {
            return;
        }
        if (bufferSource instanceof OutlineBufferSource) {
            OutlineBufferSource outline = (OutlineBufferSource)bufferSource;
            if (RenderUtils.vanillaModelAndScript(avatar) && avatar.luaRuntime.renderer.outlineColor != null) {
                int i = ColorUtils.rgbToInt(avatar.luaRuntime.renderer.outlineColor);
                outline.setColor(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF, 255);
            }
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(avatar);
        FiguraMod.pushProfiler("worldRender");
        avatar.worldRender(entity, cameraX, cameraY, cameraZ, matrices, bufferSource, this.entityRenderDispatcher.getPackedLightCoords(entity, tickDelta), tickDelta, EntityRenderMode.WORLD);
        FiguraMod.popProfiler(3);
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;checkPoseStack(Lcom/mojang/blaze3d/vertex/PoseStack;)V", ordinal=0)})
    private void renderLevelFirstPerson(DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci, @Local PoseStack stack) {
        LivingEntity livingEntity;
        MultiBufferSource.BufferSource bufferSource;
        float tickDelta;
        block7: {
            block6: {
                if (camera.isDetached()) {
                    return;
                }
                tickDelta = deltaTracker.getGameTimeDeltaPartialTick(false);
                Entity e = camera.getEntity();
                Avatar avatar = AvatarManager.getAvatar(e);
                if (avatar == null) {
                    return;
                }
                bufferSource = this.renderBuffers.bufferSource();
                avatar.firstPersonWorldRender(e, (MultiBufferSource)bufferSource, stack, camera, tickDelta);
                if (!(e instanceof LivingEntity)) break block6;
                livingEntity = (LivingEntity)e;
                if (((Boolean)Configs.FIRST_PERSON_MATRICES.value).booleanValue()) break block7;
            }
            return;
        }
        Avatar.firstPerson = true;
        int size = ((PoseStackAccessor)stack).getPoseStack().size();
        stack.pushPose();
        EntityRenderer entityRenderer = this.entityRenderDispatcher.getRenderer((Entity)livingEntity);
        Vec3 offset = entityRenderer.getRenderOffset((Entity)livingEntity, tickDelta);
        Vec3 cam = camera.getPosition();
        stack.translate(Mth.lerp((double)tickDelta, (double)livingEntity.xOld, (double)livingEntity.getX()) - cam.x() + offset.x(), Mth.lerp((double)tickDelta, (double)livingEntity.yOld, (double)livingEntity.getY()) - cam.y() + offset.y(), Mth.lerp((double)tickDelta, (double)livingEntity.zOld, (double)livingEntity.getZ()) - cam.z() + offset.z());
        float yaw = Mth.lerp((float)tickDelta, (float)livingEntity.yRotO, (float)livingEntity.getYRot());
        entityRenderer.render((Entity)livingEntity, yaw, tickDelta, stack, (MultiBufferSource)bufferSource, 0xF000F0);
        do {
            stack.popPose();
        } while (((PoseStackAccessor)stack).getPoseStack().size() > size);
        Avatar.firstPerson = false;
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="HEAD")})
    private void onRenderLevel(DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci) {
        AvatarManager.executeAll("worldRender", avatar -> avatar.render(deltaTracker.getGameTimeDeltaPartialTick(false)));
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="RETURN")})
    private void afterRenderLevel(DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci) {
        AvatarManager.executeAll("postWorldRender", avatar -> avatar.postWorldRenderEvent(deltaTracker.getGameTimeDeltaPartialTick(false)));
    }

    @ModifyArg(method={"renderHitOutline(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;DDDLnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderShape(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/shapes/VoxelShape;DDDFFFF)V"), index=6)
    private float renderHitOutlineX(float x) {
        FiguraVec4 color;
        Avatar avatar = AvatarManager.getAvatar(this.minecraft.getCameraEntity());
        if (avatar == null || avatar.luaRuntime == null || (color = avatar.luaRuntime.renderer.blockOutlineColor) == null) {
            return x;
        }
        return (float)color.x;
    }

    @ModifyArg(method={"renderHitOutline(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;DDDLnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderShape(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/shapes/VoxelShape;DDDFFFF)V"), index=7)
    private float renderHitOutlineY(float y) {
        FiguraVec4 color;
        Avatar avatar = AvatarManager.getAvatar(this.minecraft.getCameraEntity());
        if (avatar == null || avatar.luaRuntime == null || (color = avatar.luaRuntime.renderer.blockOutlineColor) == null) {
            return y;
        }
        return (float)color.y;
    }

    @ModifyArg(method={"renderHitOutline(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;DDDLnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderShape(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/shapes/VoxelShape;DDDFFFF)V"), index=8)
    private float renderHitOutlineZ(float z) {
        FiguraVec4 color;
        Avatar avatar = AvatarManager.getAvatar(this.minecraft.getCameraEntity());
        if (avatar == null || avatar.luaRuntime == null || (color = avatar.luaRuntime.renderer.blockOutlineColor) == null) {
            return z;
        }
        return (float)color.z;
    }

    @ModifyArg(method={"renderHitOutline(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;DDDLnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderShape(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/shapes/VoxelShape;DDDFFFF)V"), index=9)
    private float renderHitOutlineW(float w) {
        FiguraVec4 color;
        Avatar avatar = AvatarManager.getAvatar(this.minecraft.getCameraEntity());
        if (avatar == null || avatar.luaRuntime == null || (color = avatar.luaRuntime.renderer.blockOutlineColor) == null) {
            return w;
        }
        return (float)color.w;
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderBuffers;bufferSource()Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;")})
    public void applyFiguraNormals(DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci, @Local PoseStack poseStack) {
        Avatar avatar = AvatarManager.getAvatar((Entity)(this.minecraft.getCameraEntity() == null ? this.minecraft.player : this.minecraft.getCameraEntity()));
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return;
        }
        FiguraMat3 normal = avatar.luaRuntime.renderer.cameraNormal;
        if (normal != null) {
            poseStack.last().normal().set((Matrix3fc)normal.toMatrix3f());
        }
    }
}

