/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.particle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import org.figuramc.figura.ducks.ParticleEngineAccessor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ParticleEngine.class})
public abstract class ParticleEngineMixin
implements ParticleEngineAccessor {
    @Final
    @Shadow
    private Map<ResourceLocation, SpriteSet> spriteSets;
    @Unique
    private final HashMap<Particle, UUID> particleMap = new HashMap();

    @Shadow
    @Nullable
    protected abstract <T extends ParticleOptions> Particle makeParticle(T var1, double var2, double var4, double var6, double var8, double var10, double var12);

    @Shadow
    public abstract void add(Particle var1);

    @ModifyVariable(method={"tickParticleList(Ljava/util/Collection;)V"}, at=@At(value="INVOKE", target="Ljava/util/Iterator;remove()V", ordinal=0))
    private Particle tickParticleList(Particle particle) {
        this.particleMap.remove(particle);
        return particle;
    }

    @Override
    @Intrinsic
    public <T extends ParticleOptions> Particle figura$makeParticle(T parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        return this.makeParticle(parameters, x, y, z, velocityX, velocityY, velocityZ);
    }

    @Override
    @Intrinsic
    public void figura$spawnParticle(Particle particle, UUID owner) {
        this.particleMap.put(particle, owner);
        this.add(particle);
    }

    @Override
    @Intrinsic
    public void figura$clearParticles(UUID owner) {
        Iterator<Map.Entry<Particle, UUID>> iterator = this.particleMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Particle, UUID> entry = iterator.next();
            if (owner != null && !entry.getValue().equals(owner)) continue;
            if (entry.getKey() != null) {
                entry.getKey().remove();
            }
            iterator.remove();
        }
    }

    @Override
    @Intrinsic
    public SpriteSet figura$getParticleSprite(ResourceLocation particleID) {
        return this.spriteSets.get(particleID);
    }
}

