/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.neoforge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.component.DyedItemColor;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.compat.GeckoLibCompat;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.mixin.render.layers.HumanoidArmorLayerAccessor;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.FiguraArmorPartRenderer;
import org.figuramc.figura.utils.RenderUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidArmorLayer.class}, priority=900)
public abstract class HumanoidArmorLayerMixinNeoForge<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M>
implements HumanoidArmorLayerAccessor<T, M, A> {
    @Shadow
    @Final
    private TextureAtlas armorTrimAtlas;
    @Shadow
    @Final
    private A innerModel;
    @Shadow
    @Final
    private A outerModel;
    @Unique
    private boolean figura$renderingVanillaArmor;
    @Unique
    private Avatar figura$avatar;

    @Shadow
    protected abstract A getArmorModel(EquipmentSlot var1);

    @Shadow
    protected abstract void renderArmorPiece(PoseStack var1, MultiBufferSource var2, T var3, EquipmentSlot var4, int var5, A var6);

    public HumanoidArmorLayerMixinNeoForge(RenderLayerParent<T, M> context) {
        super(context);
    }

    @Inject(at={@At(value="HEAD")}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"})
    public void setAvatar(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        this.figura$avatar = AvatarManager.getAvatar(livingEntity);
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.AFTER, ordinal=3, target="Lnet/minecraft/client/renderer/entity/layers/HumanoidArmorLayer;renderArmorPiece(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/EquipmentSlot;ILnet/minecraft/client/model/HumanoidModel;FFFFFF)V")}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"})
    public void onRenderEnd(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        if (this.figura$avatar == null) {
            return;
        }
        this.figura$tryRenderArmorPart(EquipmentSlot.HEAD, this::figura$helmetRenderer, poseStack, livingEntity, multiBufferSource, i, ParentType.HelmetPivot);
        this.figura$tryRenderArmorPart(EquipmentSlot.CHEST, this::figura$chestplateRenderer, poseStack, livingEntity, multiBufferSource, i, ParentType.LeftShoulderPivot, ParentType.ChestplatePivot, ParentType.RightShoulderPivot);
        this.figura$tryRenderArmorPart(EquipmentSlot.LEGS, this::figura$leggingsRenderer, poseStack, livingEntity, multiBufferSource, i, ParentType.LeftLeggingPivot, ParentType.RightLeggingPivot, ParentType.LeggingsPivot);
        this.figura$tryRenderArmorPart(EquipmentSlot.FEET, this::figura$bootsRenderer, poseStack, livingEntity, multiBufferSource, i, ParentType.LeftBootPivot, ParentType.RightBootPivot);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/HumanoidArmorLayer;usesInnerModel(Lnet/minecraft/world/entity/EquipmentSlot;)Z")}, method={"renderArmorPiece(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/EquipmentSlot;ILnet/minecraft/client/model/HumanoidModel;FFFFFF)V"})
    public void onRenderArmorPiece(PoseStack poseStack, MultiBufferSource multiBufferSource, T livingEntity, EquipmentSlot equipmentSlot, int i, A humanoidModel, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (this.figura$avatar == null) {
            return;
        }
        VanillaPart part = RenderUtils.partFromSlot(this.figura$avatar, equipmentSlot);
        if (part != null) {
            part.save((EntityModel<?>)humanoidModel);
            part.preTransform((EntityModel<?>)humanoidModel);
            part.posTransform((EntityModel<?>)humanoidModel);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/HumanoidArmorLayer;setPartVisibility(Lnet/minecraft/client/model/HumanoidModel;Lnet/minecraft/world/entity/EquipmentSlot;)V", shift=At.Shift.AFTER)}, method={"renderArmorPiece(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/EquipmentSlot;ILnet/minecraft/client/model/HumanoidModel;FFFFFF)V"}, cancellable=true)
    public void renderArmorPieceHijack(PoseStack poseStack, MultiBufferSource multiBufferSource, T livintEntity, EquipmentSlot equipmentSlot, int i, A humanoidModel, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (this.figura$avatar == null) {
            return;
        }
        if (!this.figura$renderingVanillaArmor) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"renderArmorPiece(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/EquipmentSlot;ILnet/minecraft/client/model/HumanoidModel;FFFFFF)V"})
    public void postRenderArmorPiece(PoseStack poseStack, MultiBufferSource multiBufferSource, T livintEntity, EquipmentSlot equipmentSlot, int i, A humanoidModel, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (this.figura$avatar == null) {
            return;
        }
        VanillaPart part = RenderUtils.partFromSlot(this.figura$avatar, equipmentSlot);
        if (part != null) {
            part.restore((EntityModel<?>)humanoidModel);
        }
    }

    @Unique
    private void figura$tryRenderArmorPart(EquipmentSlot slot, FiguraArmorPartRenderer<T, M, A> renderer, PoseStack vanillaPoseStack, T entity, MultiBufferSource vertexConsumers, int light, ParentType ... parentTypes) {
        ArmorItem armorItem;
        if (slot == null) {
            return;
        }
        ItemStack itemStack = entity.getItemBySlot(slot);
        Item item = itemStack.getItem();
        if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).getEquipmentSlot() == slot) {
            A armorModel = this.getArmorModel(slot);
            ((HumanoidModel)armorModel).body.xRot = 0.0f;
            ((HumanoidModel)armorModel).rightLeg.z = 0.0f;
            ((HumanoidModel)armorModel).leftLeg.z = 0.0f;
            ((HumanoidModel)armorModel).rightLeg.y = 12.0f;
            ((HumanoidModel)armorModel).leftLeg.y = 12.0f;
            ((HumanoidModel)armorModel).head.y = 0.0f;
            ((HumanoidModel)armorModel).body.y = 0.0f;
            ((HumanoidModel)armorModel).leftArm.y = 2.0f;
            ((HumanoidModel)armorModel).rightArm.y = 2.0f;
            ((HumanoidModel)armorModel).leftArm.x = 5.0f;
            ((HumanoidModel)armorModel).rightArm.x = -5.0f;
            ((HumanoidModel)armorModel).leftArm.z = 0.0f;
            ((HumanoidModel)armorModel).rightArm.z = 0.0f;
            boolean allFailed = true;
            VanillaPart mainPart = RenderUtils.partFromSlot(this.figura$avatar, slot);
            int armorEditPermission = this.figura$avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT);
            if (armorEditPermission == 1 && mainPart != null && !mainPart.checkVisible()) {
                return;
            }
            if (!GeckoLibCompat.armorHasCustomModel(itemStack)) {
                for (ParentType parentType : parentTypes) {
                    VanillaPart part = RenderUtils.pivotToPart(this.figura$avatar, parentType);
                    if (armorEditPermission == 1 && part != null && !part.checkVisible()) continue;
                    boolean renderedPivot = false;
                    if (armorEditPermission == 1) {
                        renderedPivot = this.figura$avatar.pivotPartRender(parentType, stack -> {
                            stack.pushPose();
                            this.figura$prepareArmorRender((PoseStack)stack);
                            renderer.renderArmorPart((PoseStack)stack, vertexConsumers, light, armorModel, entity, itemStack, slot, armorItem, parentType);
                            stack.popPose();
                        });
                    }
                    if (!renderedPivot) continue;
                    allFailed = false;
                }
            }
            if (allFailed) {
                this.figura$renderingVanillaArmor = true;
                this.renderArmorPiece(vanillaPoseStack, vertexConsumers, entity, slot, light, armorModel);
                this.figura$renderingVanillaArmor = false;
            }
        }
    }

    @Unique
    private void figura$prepareArmorRender(PoseStack stack) {
        stack.scale(16.0f, 16.0f, 16.0f);
        stack.mulPose(Axis.XP.rotationDegrees(180.0f));
        stack.mulPose(Axis.YP.rotationDegrees(180.0f));
    }

    @Unique
    private void figura$helmetRenderer(PoseStack poseStack, MultiBufferSource vertexConsumers, int light, A model, T entity, ItemStack itemStack, EquipmentSlot armorSlot, ArmorItem armorItem, ParentType parentType) {
        if (parentType == ParentType.HelmetPivot) {
            this.figura$renderArmorPart(((HumanoidModel)model).head, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            this.figura$renderArmorPart(((HumanoidModel)model).hat, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
        }
    }

    @Unique
    private void figura$chestplateRenderer(PoseStack poseStack, MultiBufferSource vertexConsumers, int light, A model, T entity, ItemStack itemStack, EquipmentSlot armorSlot, ArmorItem armorItem, ParentType parentType) {
        if (parentType == ParentType.ChestplatePivot) {
            this.figura$renderArmorPart(((HumanoidModel)model).body, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
        }
        if (parentType == ParentType.LeftShoulderPivot) {
            poseStack.pushPose();
            poseStack.translate(-0.375f, 0.0f, 0.0f);
            this.figura$renderArmorPart(((HumanoidModel)model).leftArm, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            poseStack.popPose();
        }
        if (parentType == ParentType.RightShoulderPivot) {
            poseStack.pushPose();
            poseStack.translate(0.375f, 0.0f, 0.0f);
            this.figura$renderArmorPart(((HumanoidModel)model).rightArm, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            poseStack.popPose();
        }
    }

    @Unique
    private void figura$leggingsRenderer(PoseStack poseStack, MultiBufferSource vertexConsumers, int light, A model, T entity, ItemStack itemStack, EquipmentSlot armorSlot, ArmorItem armorItem, ParentType parentType) {
        if (parentType == ParentType.LeggingsPivot) {
            poseStack.pushPose();
            poseStack.translate(0.0f, -0.75f, 0.0f);
            this.figura$renderArmorPart(((HumanoidModel)model).body, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            poseStack.popPose();
        }
        if (parentType == ParentType.LeftLeggingPivot) {
            poseStack.pushPose();
            poseStack.translate(-0.125f, -0.75f, 0.0f);
            this.figura$renderArmorPart(((HumanoidModel)model).leftLeg, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            poseStack.popPose();
        }
        if (parentType == ParentType.RightLeggingPivot) {
            poseStack.pushPose();
            poseStack.translate(0.125f, -0.75f, 0.0f);
            this.figura$renderArmorPart(((HumanoidModel)model).rightLeg, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            poseStack.popPose();
        }
    }

    @Unique
    private void figura$bootsRenderer(PoseStack poseStack, MultiBufferSource vertexConsumers, int light, A model, T entity, ItemStack itemStack, EquipmentSlot armorSlot, ArmorItem armorItem, ParentType parentType) {
        if (parentType == ParentType.LeftBootPivot) {
            poseStack.pushPose();
            poseStack.translate(-0.125f, -1.5f, 0.0f);
            this.figura$renderArmorPart(((HumanoidModel)model).leftLeg, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            poseStack.popPose();
        }
        if (parentType == ParentType.RightBootPivot) {
            poseStack.pushPose();
            poseStack.translate(0.125f, -1.5f, 0.0f);
            this.figura$renderArmorPart(((HumanoidModel)model).rightLeg, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            poseStack.popPose();
        }
    }

    @Unique
    private void figura$renderArmorPart(ModelPart modelPart, PoseStack poseStack, MultiBufferSource vertexConsumers, int light, T entity, ItemStack itemStack, EquipmentSlot armorSlot, ArmorItem armorItem) {
        boolean bl = this.usesInnerModel(armorSlot);
        boolean hasGlint = itemStack.hasFoil();
        modelPart.visible = true;
        modelPart.xRot = 0.0f;
        modelPart.yRot = 0.0f;
        modelPart.zRot = 0.0f;
        int i = itemStack.is(ItemTags.DYEABLE) ? DyedItemColor.getOrDefault((ItemStack)itemStack, (int)-6265536) : -1;
        ArmorMaterial material = (ArmorMaterial)armorItem.getMaterial().value();
        for (ArmorMaterial.Layer layer : material.layers()) {
            ResourceLocation normalArmorResource = RenderUtils.getArmorResource(entity, itemStack, armorItem, armorSlot, bl, layer);
            VertexConsumer regularArmorConsumer = vertexConsumers.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)normalArmorResource));
            modelPart.render(poseStack, regularArmorConsumer, light, OverlayTexture.NO_OVERLAY, i);
        }
        ArmorTrim trim = (ArmorTrim)itemStack.get(DataComponents.TRIM);
        if (trim != null) {
            Holder armorMaterial = armorItem.getMaterial();
            TextureAtlasSprite trimAtlas = this.armorTrimAtlas.getSprite(bl ? trim.innerTexture(armorMaterial) : trim.outerTexture(armorMaterial));
            VertexConsumer trimConsumer = trimAtlas.wrap(vertexConsumers.getBuffer(Sheets.armorTrimsSheet((boolean)false)));
            modelPart.render(poseStack, trimConsumer, light, OverlayTexture.NO_OVERLAY, -1);
        }
        if (hasGlint) {
            modelPart.render(poseStack, vertexConsumers.getBuffer(RenderType.armorEntityGlint()), light, OverlayTexture.NO_OVERLAY, -1);
        }
    }
}

