/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.world.level.Level;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientPacketListener.class}, priority=999)
public abstract class ClientPacketListenerMixin {
    @Shadow
    public abstract ClientLevel getLevel();

    @Inject(at={@At(value="HEAD")}, method={"sendUnsignedCommand(Ljava/lang/String;)Z"}, cancellable=true)
    private void sendUnsignedCommand(String command, CallbackInfoReturnable<Boolean> cir) {
        if (command.startsWith("figura")) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"handleEntityEvent(Lnet/minecraft/network/protocol/game/ClientboundEntityEventPacket;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/core/particles/ParticleTypes;TOTEM_OF_UNDYING:Lnet/minecraft/core/particles/SimpleParticleType;")}, cancellable=true)
    private void handleTotem(ClientboundEntityEventPacket packet, CallbackInfo ci) {
        ClientLevel level = this.getLevel();
        Avatar avatar = AvatarManager.getAvatar(packet.getEntity((Level)level));
        if (avatar != null && avatar.totemEvent()) {
            ci.cancel();
        }
    }
}

