/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.ducks.ParticleEngineAccessor;
import org.figuramc.figura.lua.LuaNotNil;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.particle.LuaParticle;
import org.figuramc.figura.lua.api.world.WorldAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.utils.LuaUtils;
import org.luaj.vm2.LuaError;

@LuaWhitelist
@LuaTypeDoc(name="ParticleAPI", value="particles")
public class ParticleAPI {
    private final Avatar owner;

    public ParticleAPI(Avatar owner) {
        this.owner = owner;
    }

    public static ParticleEngineAccessor getParticleEngine() {
        return (ParticleEngineAccessor)Minecraft.getInstance().particleEngine;
    }

    private LuaParticle generate(String id, double x, double y, double z, double w, double t, double h) {
        try {
            id = this.convertOldToNewParticleFormat(id);
            ParticleOptions options = ParticleArgument.readParticle((StringReader)new StringReader(id), (HolderLookup.Provider)WorldAPI.getCurrentWorld().registryAccess());
            Particle p = ParticleAPI.getParticleEngine().figura$makeParticle(options, x, y, z, w, t, h);
            if (p == null) {
                throw new LuaError("Could not parse particle \"" + id + "\"");
            }
            return new LuaParticle(id, p, this.owner);
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
    }

    private String convertOldToNewParticleFormat(String id) {
        if (((String)id).contains("block ")) {
            id = ((String)id).replaceFirst("minecraft:", "");
            String blockPart = ((String)id).split("block ")[1];
            Object ret = "block{block_state:{";
            if (blockPart.contains("[")) {
                String blockName = blockPart.split("\\[")[0];
                String properties = ((String)id).substring(((String)id).indexOf("[") + 1, ((String)id).indexOf("]") + 1);
                properties = properties.replaceAll("=", ":\"").replaceAll(",", "\",").replace("]", "\"");
                ret = (String)ret + "Name:\"" + blockName + "\",Properties:{" + properties + "}";
            } else {
                String blockName = blockPart;
                ret = (String)ret + "Name:\"" + blockName + "\"";
            }
            id = ret = (String)ret + "}}";
        } else if (((String)id).contains("block_marker ")) {
            id = ((String)id).replaceFirst("minecraft:", "");
            String blockPart = ((String)id).split("block_marker ")[1];
            Object ret = "block_marker{block_state:{";
            if (blockPart.contains("[")) {
                String blockName = blockPart.split("\\[")[0];
                String properties = ((String)id).substring(((String)id).indexOf("[") + 1, ((String)id).indexOf("]") + 1);
                properties = properties.replaceAll("=", ":\"").replaceAll(",", "\",").replace("]", "\"");
                ret = (String)ret + "Name:\"" + blockName + "\",Properties:{" + properties + "}";
            } else {
                String blockName = blockPart;
                ret = (String)ret + "Name:\"" + blockName + "\"";
            }
            id = ret = (String)ret + "}}";
        } else if (((String)id).contains("falling_dust ")) {
            id = ((String)id).replaceFirst("minecraft:", "");
            String blockPart = ((String)id).split("falling_dust ")[1];
            Object ret = "falling_dust{block_state:{";
            if (blockPart.contains("[")) {
                String blockName = blockPart.split("\\[")[0];
                String properties = ((String)id).substring(((String)id).indexOf("[") + 1, ((String)id).indexOf("]") + 1);
                properties = properties.replaceAll("=", ":\"").replaceAll(",", "\",").replace("]", "\"");
                ret = (String)ret + "Name:\"" + blockName + "\",Properties:{" + properties + "}";
            } else {
                String blockName = blockPart;
                ret = (String)ret + "Name:\"" + blockName + "\"";
            }
            id = ret = (String)ret + "}}";
        } else if (((String)id).contains("dust ")) {
            id = ((String)id).replaceFirst("minecraft:", "");
            String[] parts = ((String)id).split(" ");
            Object ret = "dust{";
            if (Objects.equals(parts[0], "dust")) {
                Object num1 = parts[1];
                Object num2 = parts[2];
                Object num3 = parts[3];
                if (!((String)num1).contains(".")) {
                    num1 = (String)num1 + ".0";
                }
                if (!((String)num2).contains(".")) {
                    num2 = (String)num2 + ".0";
                }
                if (!((String)num3).contains(".")) {
                    num3 = (String)num3 + ".0";
                }
                ret = (String)ret + "color:[" + (String)num1 + "," + (String)num2 + "," + (String)num3 + "],scale:" + parts[4];
            }
            id = ret = (String)ret + "}";
        } else if (((String)id).contains("dust_color_transition ")) {
            id = ((String)id).replaceFirst("minecraft:", "");
            String[] parts = ((String)id).split(" ");
            Object ret = "dust_color_transition{";
            if (Objects.equals(parts[0], "dust_color_transition")) {
                Object rFrom = parts[1];
                Object gFrom = parts[2];
                Object bFrom = parts[3];
                if (!((String)rFrom).contains(".")) {
                    rFrom = (String)rFrom + ".0";
                }
                if (!((String)gFrom).contains(".")) {
                    gFrom = (String)gFrom + ".0";
                }
                if (!((String)bFrom).contains(".")) {
                    bFrom = (String)bFrom + ".0";
                }
                String scale = parts[4];
                Object rTo = parts[5];
                Object gTo = parts[6];
                Object bTo = parts[7];
                if (!((String)rTo).contains(".")) {
                    rTo = (String)rTo + ".0";
                }
                if (!((String)gTo).contains(".")) {
                    gTo = (String)gTo + ".0";
                }
                if (!((String)bTo).contains(".")) {
                    bTo = (String)bTo + ".0";
                }
                ret = (String)ret + "from_color:[" + (String)rFrom + "," + (String)gFrom + "," + (String)bFrom + "],scale:" + scale + ",to_color:[" + (String)rTo + "," + (String)gTo + "," + (String)bTo + "]";
            }
            id = ret = (String)ret + "}";
        } else if (((String)id).contains("item ")) {
            id = ((String)id).replaceFirst("minecraft:", "");
            String[] parts = ((String)id).split(" ");
            Object ret = "item{";
            if (Objects.equals(parts[0], "item")) {
                String itemId = parts[1];
                ret = (String)ret + "item:{id:" + itemId + "}";
            }
            id = ret = (String)ret + "}";
        } else if (((String)id).contains("sculk_charge ")) {
            id = ((String)id).replaceFirst("minecraft:", "");
            String[] parts = ((String)id).split(" ");
            Object ret = "sculk_charge{";
            if (Objects.equals(parts[0], "sculk_charge")) {
                String roll = parts[1];
                ret = (String)ret + "roll:" + roll;
            }
            id = ret = (String)ret + "}";
        } else if (((String)id).contains("shriek ")) {
            id = ((String)id).replaceFirst("minecraft:", "");
            String[] parts = ((String)id).split(" ");
            Object ret = "shriek{";
            if (Objects.equals(parts[0], "shriek")) {
                String delay = parts[1];
                ret = (String)ret + "delay:" + delay;
            }
            id = ret = (String)ret + "}";
        } else if (((String)id).contains("vibration ")) {
            id = ((String)id).replaceFirst("minecraft:", "");
            String[] parts = ((String)id).split(" ");
            Object ret = "vibration{";
            if (Objects.equals(parts[0], "vibration")) {
                String dsX = parts[1];
                String dsY = parts[2];
                String dsZ = parts[3];
                String arr = parts[4];
                ret = (String)ret + "arrival_in_ticks:" + arr + ",destination:{type:block,pos:[" + dsX + "," + dsY + "," + dsZ + "]}";
            }
            id = ret = (String)ret + "}";
        } else if (((String)id).contains("entity_effect") && !((String)id).contains("{")) {
            id = (String)id + "{color:[0.0,0.0,0.0,1.0]}";
        }
        return id;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, FiguraVec3.class}, argumentNames={"name", "pos"}), @LuaMethodOverload(argumentTypes={String.class, FiguraVec3.class, FiguraVec3.class}, argumentNames={"name", "pos", "vel"}), @LuaMethodOverload(argumentTypes={String.class, Double.class, Double.class, Double.class}, argumentNames={"name", "posX", "posY", "posZ"}), @LuaMethodOverload(argumentTypes={String.class, FiguraVec3.class, Double.class, Double.class, Double.class}, argumentNames={"name", "pos", "velX", "velY", "velZ"}), @LuaMethodOverload(argumentTypes={String.class, Double.class, Double.class, Double.class, FiguraVec3.class}, argumentNames={"name", "posX", "posY", "posZ", "vel"}), @LuaMethodOverload(argumentTypes={String.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class}, argumentNames={"name", "posX", "posY", "posZ", "velX", "velY", "velZ"})}, value="particles.new_particle")
    public LuaParticle newParticle(@LuaNotNil String id, Object x, Object y, Double z, Object w, Double t, Double h) {
        Pair<FiguraVec3, FiguraVec3> pair = LuaUtils.parse2Vec3("newParticle", x, y, z, w, t, h, 2);
        FiguraVec3 pos = (FiguraVec3)pair.getFirst();
        FiguraVec3 vel = (FiguraVec3)pair.getSecond();
        LuaParticle particle = this.generate(id, pos.x, pos.y, pos.z, vel.x, vel.y, vel.z);
        particle.spawn();
        return particle;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="particles.remove_particles")
    public ParticleAPI removeParticles() {
        ParticleAPI.getParticleEngine().figura$clearParticles(this.owner.owner);
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"id"})}, value="particles.is_present")
    public boolean isPresent(String id) {
        try {
            ParticleOptions options = ParticleArgument.readParticle((StringReader)new StringReader(id), (HolderLookup.Provider)WorldAPI.getCurrentWorld().registryAccess());
            return ParticleAPI.getParticleEngine().figura$makeParticle(options, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) != null;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @LuaWhitelist
    public LuaParticle __index(String id) {
        return this.generate(id, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public String toString() {
        return "ParticleAPI";
    }
}

