/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.entity;

import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.entity.EntityAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.mixin.LivingEntityAccessor;

@LuaWhitelist
@LuaTypeDoc(name="LivingEntityAPI", value="living_entity")
public class LivingEntityAPI<T extends LivingEntity>
extends EntityAPI<T> {
    public LivingEntityAPI(T entity) {
        super(entity);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"delta"})}, value="living_entity.get_body_yaw")
    public double getBodyYaw(Float delta) {
        this.checkEntity();
        if (delta == null) {
            delta = Float.valueOf(1.0f);
        }
        return Mth.lerp((float)delta.floatValue(), (float)((LivingEntity)this.entity).yBodyRotO, (float)((LivingEntity)this.entity).yBodyRot);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"offhand"})}, value="living_entity.get_held_item")
    public ItemStackAPI getHeldItem(boolean offhand) {
        this.checkEntity();
        return ItemStackAPI.verify(offhand ? ((LivingEntity)this.entity).getOffhandItem() : ((LivingEntity)this.entity).getMainHandItem());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_active_item")
    public ItemStackAPI getActiveItem() {
        this.checkEntity();
        return ItemStackAPI.verify(((LivingEntity)this.entity).getUseItem());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_active_item_time")
    public int getActiveItemTime() {
        this.checkEntity();
        return ((LivingEntity)this.entity).getTicksUsingItem();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_health")
    public float getHealth() {
        this.checkEntity();
        return ((LivingEntity)this.entity).getHealth();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_max_health")
    public float getMaxHealth() {
        this.checkEntity();
        return ((LivingEntity)this.entity).getMaxHealth();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_armor")
    public float getArmor() {
        this.checkEntity();
        return ((LivingEntity)this.entity).getArmorValue();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_death_time")
    public float getDeathTime() {
        this.checkEntity();
        return ((LivingEntity)this.entity).deathTime;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_arrow_count")
    public int getArrowCount() {
        this.checkEntity();
        return ((LivingEntity)this.entity).getArrowCount();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_stinger_count")
    public int getStingerCount() {
        this.checkEntity();
        return ((LivingEntity)this.entity).getStingerCount();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_left_handed")
    public boolean isLeftHanded() {
        this.checkEntity();
        return ((LivingEntity)this.entity).getMainArm() == HumanoidArm.LEFT;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_using_item")
    public boolean isUsingItem() {
        this.checkEntity();
        return ((LivingEntity)this.entity).isUsingItem();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_active_hand")
    public String getActiveHand() {
        this.checkEntity();
        return ((LivingEntity)this.entity).getUsedItemHand().name();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_climbing")
    public boolean isClimbing() {
        this.checkEntity();
        return ((LivingEntity)this.entity).onClimbable();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_swing_time")
    public int getSwingTime() {
        this.checkEntity();
        return ((LivingEntity)this.entity).swingTime;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_swinging_arm")
    public boolean isSwingingArm() {
        this.checkEntity();
        return ((LivingEntity)this.entity).swinging;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_swing_arm")
    public String getSwingArm() {
        this.checkEntity();
        return ((LivingEntity)this.entity).swinging ? ((LivingEntity)this.entity).swingingArm.name() : null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_swing_duration")
    public int getSwingDuration() {
        this.checkEntity();
        return ((LivingEntityAccessor)this.entity).getSwingDuration();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_absorption_amount")
    public float getAbsorptionAmount() {
        this.checkEntity();
        return ((LivingEntity)this.entity).getAbsorptionAmount();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_sensitive_to_water")
    public boolean isSensitiveToWater() {
        this.checkEntity();
        return ((LivingEntity)this.entity).isSensitiveToWater();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_entity_category")
    public String getEntityCategory() {
        this.checkEntity();
        EntityType mobType = ((LivingEntity)this.entity).getType();
        if (mobType.is(EntityTypeTags.ARTHROPOD)) {
            return "ARTHROPOD";
        }
        if (mobType.is(EntityTypeTags.UNDEAD)) {
            return "UNDEAD";
        }
        if (mobType.is(EntityTypeTags.AQUATIC)) {
            return "WATER";
        }
        if (mobType.is(EntityTypeTags.ILLAGER)) {
            return "ILLAGER";
        }
        return "UNDEFINED";
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_gliding")
    public boolean isGliding() {
        this.checkEntity();
        return ((LivingEntity)this.entity).isFallFlying();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_blocking")
    public boolean isBlocking() {
        this.checkEntity();
        return ((LivingEntity)this.entity).isBlocking();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_visually_swimming")
    public boolean isVisuallySwimming() {
        this.checkEntity();
        return ((LivingEntity)this.entity).isVisuallySwimming();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.riptide_spinning")
    public boolean riptideSpinning() {
        this.checkEntity();
        return ((LivingEntity)this.entity).isAutoSpinAttack();
    }

    @Override
    public String toString() {
        this.checkEntity();
        return (String)(((LivingEntity)this.entity).hasCustomName() ? ((LivingEntity)this.entity).getCustomName().getString() + " (" + this.getType() + ")" : this.getType()) + " (LivingEntity)";
    }
}

