/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua;

import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import org.figuramc.figura.lua.api.world.WorldAPI;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class NbtToLua {
    private static final HashMap<Class<?>, Function<Tag, LuaValue>> CONVERTERS = new HashMap<Class<?>, Function<Tag, LuaValue>>(){
        {
            this.put(ByteTag.class, tag -> LuaValue.valueOf((int)((ByteTag)tag).getAsByte()));
            this.put(ShortTag.class, tag -> LuaValue.valueOf((int)((ShortTag)tag).getAsShort()));
            this.put(IntTag.class, tag -> LuaValue.valueOf((int)((IntTag)tag).getAsInt()));
            this.put(LongTag.class, tag -> LuaValue.valueOf((double)((LongTag)tag).getAsLong()));
            this.put(FloatTag.class, tag -> LuaValue.valueOf((double)((FloatTag)tag).getAsFloat()));
            this.put(DoubleTag.class, tag -> LuaValue.valueOf((double)((DoubleTag)tag).getAsDouble()));
            this.put(CompoundTag.class, tag -> {
                LuaTable table = new LuaTable();
                CompoundTag compound = (CompoundTag)tag;
                for (String key : compound.getAllKeys()) {
                    table.set(key, NbtToLua.convert(compound.get(key)));
                }
                return table;
            });
            this.put(ByteArrayTag.class, tag -> NbtToLua.fromCollection((CollectionTag)tag));
            this.put(IntArrayTag.class, tag -> NbtToLua.fromCollection((CollectionTag)tag));
            this.put(LongArrayTag.class, tag -> NbtToLua.fromCollection((CollectionTag)tag));
            this.put(ListTag.class, tag -> NbtToLua.fromCollection((CollectionTag)tag));
        }
    };

    private static LuaValue fromCollection(CollectionTag<?> tag) {
        LuaTable table = new LuaTable();
        int i = 1;
        for (Tag children : tag) {
            table.set(i, NbtToLua.convert(children));
            ++i;
        }
        return table;
    }

    public static LuaValue convert(Tag tag) {
        if (tag == null) {
            return null;
        }
        Class clazz = tag.getClass();
        Function<Tag, LuaValue> builder = CONVERTERS.get(clazz);
        if (builder == null) {
            return LuaValue.valueOf((String)tag.getAsString());
        }
        return builder.apply(tag);
    }

    public static CompoundTag convertToNbt(DataComponentMap components) {
        if (components == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        RegistryOps dynamicOps = WorldAPI.getCurrentWorld().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        components.forEach(arg_0 -> NbtToLua.lambda$convertToNbt$0((DynamicOps)dynamicOps, tag, arg_0));
        return tag;
    }

    private static /* synthetic */ void lambda$convertToNbt$0(DynamicOps dynamicOps, CompoundTag tag, TypedDataComponent typedDataComponent) {
        Optional optional = typedDataComponent.encodeValue(dynamicOps).result();
        ResourceLocation resourceLocation = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)typedDataComponent.type());
        if (optional.isPresent() && resourceLocation != null) {
            tag.put(resourceLocation.toString(), (Tag)optional.get());
        }
    }
}

