/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.lists;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.gui.widgets.FiguraWidget;
import org.figuramc.figura.gui.widgets.SwitchButton;
import org.figuramc.figura.gui.widgets.TextField;
import org.figuramc.figura.gui.widgets.lists.AbstractList;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;
import org.figuramc.figura.wizards.AvatarWizard;
import org.figuramc.figura.wizards.WizardEntry;

public class AvatarWizardList
extends AbstractList {
    private final AvatarWizard wizard;
    private final Map<Component, List<GuiEventListener>> map = new LinkedHashMap<Component, List<GuiEventListener>>();

    public AvatarWizardList(int x, int y, int width, int height, AvatarWizard wizard) {
        super(x, y, width, height);
        this.wizard = wizard;
        this.generate();
    }

    @Override
    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        UIHelper.blitSliced(gui, x, y, width, height, UIHelper.OUTLINE_FILL);
        this.enableScissors(gui);
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(font);
        int lineHeight = 9 + 8;
        int entryHeight = 24;
        int size = 0;
        for (List<GuiEventListener> list : this.map.values()) {
            for (GuiEventListener guiEventListener : list) {
                if (guiEventListener instanceof WizardInputBox) {
                    WizardInputBox ib = (WizardInputBox)guiEventListener;
                    ib.setVisible(this.wizard.checkDependency(ib.entry));
                    if (!ib.isVisible()) continue;
                    ++size;
                    continue;
                }
                if (!(guiEventListener instanceof WizardToggleButton)) continue;
                WizardToggleButton tb = (WizardToggleButton)guiEventListener;
                tb.setVisible(this.wizard.checkDependency(tb.entry));
                if (!tb.isVisible()) continue;
                ++size;
            }
        }
        int totalHeight = entryHeight * size + lineHeight * this.map.size();
        this.scrollBar.setVisible(totalHeight > height);
        this.scrollBar.setScrollRatio(entryHeight, totalHeight - height);
        int yOffset = this.scrollBar.isVisible() ? (int)(-Mth.lerp((double)this.scrollBar.getScrollProgress(), (double)-4.0, (double)(totalHeight - height))) : 4;
        for (Map.Entry entry : this.map.entrySet()) {
            List value = (List)entry.getValue();
            if (value.isEmpty()) continue;
            int newY = yOffset + lineHeight;
            for (GuiEventListener w : (List)entry.getValue()) {
                FiguraWidget widget = (FiguraWidget)w;
                if (!widget.isVisible()) continue;
                widget.setY(y + newY);
                newY += entryHeight;
            }
            if (newY == yOffset + lineHeight) continue;
            gui.drawCenteredString(font, (Component)entry.getKey(), x + width / 2, y + yOffset + 4, 0xFFFFFF);
            yOffset = newY;
        }
        super.render(gui, mouseX, mouseY, delta);
        gui.disableScissor();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (GuiEventListener guiEventListener : this.children()) {
            if (!(guiEventListener instanceof TextField)) continue;
            TextField field = (TextField)guiEventListener;
            field.getField().setFocused(field.isEnabled() && field.isMouseOver(mouseX, mouseY));
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void generate() {
        for (List<GuiEventListener> value : this.map.values()) {
            this.children.removeAll(value);
        }
        this.map.clear();
        int x = this.getX() + this.getWidth() / 2 + 4;
        int width = this.getWidth() / 2 - 20;
        MutableComponent lastName = Component.empty();
        ArrayList<FiguraWidget> lastList = new ArrayList<FiguraWidget>();
        for (WizardEntry value : WizardEntry.all()) {
            switch (value.type) {
                case CATEGORY: {
                    if (!lastList.isEmpty()) {
                        this.map.put((Component)lastName, lastList);
                        this.children.addAll(lastList);
                    }
                    lastName = FiguraText.of("gui.avatar_wizard." + value.name.toLowerCase(Locale.US));
                    lastList = new ArrayList();
                    break;
                }
                case TEXT: {
                    lastList.add(new WizardInputBox(x, width, this, value));
                    break;
                }
                case TOGGLE: {
                    lastList.add(new WizardToggleButton(x, width, this, value));
                }
            }
        }
        this.map.put((Component)lastName, lastList);
        this.children.addAll(lastList);
    }

    private static class WizardInputBox
    extends TextField {
        private final AvatarWizardList parent;
        private final WizardEntry entry;
        private final Component name;

        public WizardInputBox(int x, int width, AvatarWizardList parent, WizardEntry entry) {
            super(x, 0, width, 20, TextField.HintType.ANY, s -> parent.wizard.changeEntry(entry, s));
            this.parent = parent;
            this.entry = entry;
            this.name = FiguraText.of("gui.avatar_wizard." + entry.name.toLowerCase(Locale.US));
            this.getField().setValue(String.valueOf(parent.wizard.getEntry(entry, "")));
        }

        @Override
        public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            if (!this.isVisible()) {
                return;
            }
            super.render(gui, mouseX, mouseY, delta);
            Font font = Minecraft.getInstance().font;
            MutableComponent name = this.name.copy();
            if (!this.getField().getValue().isBlank()) {
                name.setStyle(FiguraMod.getAccentColor());
            }
            int n = this.getX() - this.getWidth() - 8;
            float f = this.getY();
            int n2 = this.getHeight();
            Objects.requireNonNull(font);
            gui.drawString(font, (Component)name, n, (int)(f + (float)(n2 - 9) / 2.0f), 0xFFFFFF);
        }

        @Override
        public boolean isMouseOver(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.isMouseOver(mouseX, mouseY);
        }
    }

    private static class WizardToggleButton
    extends SwitchButton {
        private final AvatarWizardList parent;
        private final WizardEntry entry;

        public WizardToggleButton(int x, int width, AvatarWizardList parent, WizardEntry entry) {
            super(x, 0, width, 20, (Component)FiguraText.of("gui.avatar_wizard." + entry.name.toLowerCase(Locale.US)), false);
            this.parent = parent;
            this.entry = entry;
            this.setToggled((Boolean)parent.wizard.getEntry(entry, false));
        }

        @Override
        public void onPress() {
            super.onPress();
            this.parent.wizard.changeEntry(this.entry, this.isToggled());
        }

        @Override
        protected void renderDefaultTexture(GuiGraphics gui, float delta) {
            PoseStack pose = gui.pose();
            pose.pushPose();
            pose.translate((float)(this.getWidth() - 30), 0.0f, 0.0f);
            super.renderDefaultTexture(gui, delta);
            pose.popPose();
        }

        @Override
        protected void renderText(GuiGraphics gui, float delta) {
            Font font = Minecraft.getInstance().font;
            MutableComponent name = this.getMessage().copy();
            if (this.isToggled()) {
                name.withStyle(FiguraMod.getAccentColor());
            }
            int n = this.getX() - this.getWidth() - 8;
            float f = this.getY();
            int n2 = this.getHeight();
            Objects.requireNonNull(font);
            gui.drawString(font, (Component)name, n, (int)(f + (float)(n2 - 9) / 2.0f), 0xFFFFFF);
        }

        @Override
        public boolean isMouseOver(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.isMouseOver(mouseX, mouseY);
        }
    }
}

