/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.config;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.ConfigType;
import org.figuramc.figura.gui.widgets.ContextMenu;
import org.figuramc.figura.gui.widgets.ParentedButton;
import org.figuramc.figura.gui.widgets.config.AbstractConfigElement;
import org.figuramc.figura.gui.widgets.config.CategoryWidget;
import org.figuramc.figura.gui.widgets.lists.ConfigList;
import org.figuramc.figura.utils.ui.UIHelper;

public class EnumElement
extends AbstractConfigElement {
    private final List<Component> names;
    private final ParentedButton button;
    private ContextMenu context;

    public EnumElement(int width, ConfigType.EnumConfig config, ConfigList parentList, CategoryWidget parentCategory) {
        super(width, config, parentList, parentCategory);
        this.names = config.enumList;
        int selectedIndex = (Integer)this.config.tempValue % this.names.size();
        this.button = new ParentedButton(0, 0, 90, 20, this.names.get(selectedIndex), this, button -> {
            this.context.setVisible(!this.context.isVisible());
            if (this.context.isVisible()) {
                this.updateContextText();
                UIHelper.setContext(this.context);
            }
        }){

            @Override
            protected void renderText(GuiGraphics gui, float delta) {
                Font font = Minecraft.getInstance().font;
                Component arrow = EnumElement.this.context.isVisible() ? UIHelper.DOWN_ARROW : UIHelper.UP_ARROW;
                int arrowWidth = font.width((FormattedText)arrow);
                Component message = this.getMessage();
                int textWidth = font.width((FormattedText)message);
                int color = this.getTextColor();
                UIHelper.renderCenteredScrollingText(gui, message, this.getX() + 1, this.getY(), this.getWidth() - (textWidth <= this.getWidth() - arrowWidth - 9 ? 0 : arrowWidth + 1) - 2, this.getHeight(), color);
                int n = this.getX() + this.getWidth() - arrowWidth - 3;
                float f = (float)this.getY() + (float)this.getHeight() / 2.0f;
                Objects.requireNonNull(font);
                gui.drawString(font, arrow, n, (int)(f - 9.0f / 2.0f), color);
            }

            @Override
            public void setHovered(boolean hovered) {
                if (!hovered && UIHelper.getContext() == EnumElement.this.context && EnumElement.this.context.isVisible()) {
                    hovered = true;
                }
                super.setHovered(hovered);
            }
        };
        this.children.add(0, this.button);
        this.button.setActive(FiguraMod.debugModeEnabled() || !config.disabled);
        if (config.enumTooltip != null) {
            this.button.setTooltip(config.enumTooltip.get(selectedIndex));
        }
        this.context = new ContextMenu((GuiEventListener)this.button, this.button.getWidth());
        for (int i = 0; i < this.names.size(); ++i) {
            int finalI = i;
            Component tooltip = config.enumTooltip != null ? config.enumTooltip.get(i) : null;
            this.context.addAction(this.names.get(i), tooltip, button1 -> {
                config.tempValue = finalI;
            });
        }
    }

    @Override
    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        this.resetButton.setActive(!this.isDefault());
        int selectedIndex = (Integer)this.config.tempValue % this.names.size();
        Component text = this.names.get(selectedIndex);
        if (this.isChanged()) {
            text = text.copy().setStyle(FiguraMod.getAccentColor());
        }
        this.button.setMessage(text);
        List<Component> tooltip = ((ConfigType.EnumConfig)this.config).enumTooltip;
        if (tooltip != null) {
            this.button.setTooltip(tooltip.get(selectedIndex));
        }
        super.render(gui, mouseX, mouseY, delta);
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.button.setX(x + this.getWidth() - 154);
        this.context.setX(this.button.getX() + this.button.getWidth() / 2 - this.context.getWidth() / 2);
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.button.setY(y);
        this.context.setY(this.button.getY() + 20);
    }

    private void updateContextText() {
        List<? extends AbstractWidget> entries = this.context.getEntries();
        for (int i = 0; i < this.names.size(); ++i) {
            Component text = this.names.get(i);
            if (i == (Integer)this.config.tempValue % this.names.size()) {
                text = Component.empty().setStyle(FiguraMod.getAccentColor()).withStyle(ChatFormatting.UNDERLINE).append(text);
            }
            entries.get(i).setMessage(text);
        }
    }
}

