/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.avatar;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.local.LocalAvatarFetcher;
import org.figuramc.figura.font.Emojis;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.avatar.AbstractAvatarWidget;
import org.figuramc.figura.gui.widgets.lists.AvatarList;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FileTexture;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class AvatarWidget
extends AbstractAvatarWidget {
    public static final ResourceLocation MISSING_ICON = new FiguraIdentifier("textures/gui/unknown_icon.png");

    public AvatarWidget(final int depth, int width, final LocalAvatarFetcher.AvatarPath avatar, AvatarList parent) {
        super(depth, width, 24, avatar, parent);
        final AvatarWidget instance = this;
        MutableComponent description = Emojis.applyEmojis((Component)Component.literal((String)avatar.getDescription()));
        this.button = new Button(this.getX(), this.getY(), width, 24, this.getName(), null, button -> {
            AvatarManager.loadLocalAvatar(avatar.getPath());
            AvatarList.selectedEntry = avatar.getTheActualPathForThis();
        }, (Component)description, parent){
            final /* synthetic */ Component val$description;
            final /* synthetic */ AvatarList val$parent;
            {
                this.val$description = component;
                this.val$parent = avatarList;
                super(x, y, width, height, text, tooltip, pressAction);
            }

            @Override
            public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float delta) {
                super.renderWidget(gui, mouseX, mouseY, delta);
                if (instance.isOf(AvatarList.selectedEntry)) {
                    UIHelper.fillOutline(gui, this.getX(), this.getY(), this.getWidth(), this.getHeight(), -1);
                }
            }

            @Override
            protected void renderText(GuiGraphics gui, float delta) {
                Font font = Minecraft.getInstance().font;
                int space = 6 * depth;
                int width = this.getWidth() - 26 - space;
                int x = this.getX() + 2 + space;
                int y = this.getY() + 2;
                FileTexture texture = avatar.getIcon();
                ResourceLocation icon = texture == null ? MISSING_ICON : texture.getLocation();
                UIHelper.blit(gui, x, y, 20, 20, icon);
                Component parsedName = TextUtils.trimToWidthEllipsis(font, this.getMessage(), width, (Component)TextUtils.ELLIPSIS.copy().withStyle(this.getMessage().getStyle()));
                gui.drawString(font, parsedName, x + 22, y, -1);
                Component parsedDescription = TextUtils.trimToWidthEllipsis(font, this.val$description, width, (Component)TextUtils.ELLIPSIS.copy().withStyle(this.val$description.getStyle()));
                Objects.requireNonNull(font);
                gui.drawString(font, parsedDescription, x + 22, y + 9 + 1, ChatFormatting.GRAY.getColor().intValue());
                if (parsedName != this.getMessage() || parsedDescription != this.val$description) {
                    Component tooltip = instance.getName();
                    if (!this.val$description.getString().isBlank()) {
                        tooltip = tooltip.copy().append("\n\n").append(this.val$description);
                    }
                    this.setTooltip(tooltip);
                }
            }

            @Override
            public boolean isMouseOver(double mouseX, double mouseY) {
                return this.val$parent.isInsideScissors(mouseX, mouseY) && super.isMouseOver(mouseX, mouseY);
            }

            @Override
            public void setHovered(boolean hovered) {
                if (!hovered && UIHelper.getContext() == AvatarWidget.this.context && AvatarWidget.this.context.isVisible()) {
                    hovered = true;
                }
                super.setHovered(hovered);
            }
        };
        this.button.shouldHaveBackground(false);
        this.children.add(this.button);
    }
}

