/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.figuramc.figura.gui.widgets.AbstractContainerElement;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class TextField
extends AbstractContainerElement {
    public static final ResourceLocation BACKGROUND = new FiguraIdentifier("textures/gui/text_field.png");
    public static final int ENABLED_COLOR = ChatFormatting.WHITE.getColor();
    public static final int DISABLED_COLOR = ChatFormatting.DARK_GRAY.getColor();
    private final HintType hint;
    private final EditBox field;
    private int borderColour = -1;
    private boolean enabled = true;

    public TextField(int x, int y, int width, int height, HintType hint, Consumer<String> changedListener) {
        super(x, y, width, height);
        this.hint = hint;
        this.field = new EditBox(Minecraft.getInstance().font, x + 4, y + (height - 8) / 2, width - 12, height - (height - 8) / 2, (Component)Component.empty());
        this.field.setMaxLength(Short.MAX_VALUE);
        this.field.setBordered(false);
        this.field.setResponder(changedListener);
        this.children.add(this.field);
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        UIHelper.blitSliced(gui, this.getX(), this.getY(), this.getWidth(), this.getHeight(), !this.isEnabled() ? 0.0f : (this.isMouseOver(mouseX, mouseY) ? 32.0f : 16.0f), 0.0f, 16, 16, 48, 16, BACKGROUND);
        if (this.isFocused()) {
            UIHelper.fillOutline(gui, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.borderColour);
        }
        if (this.hint != null && this.field.getValue().isEmpty() && !this.field.isFocused()) {
            this.renderHint(gui);
        }
        super.render(gui, mouseX, mouseY, delta);
    }

    protected void renderHint(GuiGraphics gui) {
        Font font = Minecraft.getInstance().font;
        MutableComponent mutableComponent = this.hint.hint.copy().append(TextUtils.ELLIPSIS).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});
        int n = this.getX() + 4;
        int n2 = this.getY();
        int n3 = this.getHeight();
        Objects.requireNonNull(font);
        gui.drawString(font, (Component)mutableComponent, n, n2 + (int)((float)(n3 - 9 + 1) / 2.0f), 0xFFFFFF);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isEnabled() || !this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        mouseX = Mth.clamp((double)mouseX, (double)this.field.getX(), (double)(this.field.getX() + this.field.getWidth() - 1));
        mouseY = Mth.clamp((double)mouseY, (double)this.field.getY(), (double)(this.field.getY() + this.field.getHeight() - 1));
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return !this.field.isFocused();
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.field.setX(x + 4);
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.field.setY(y + (this.getHeight() - 8) / 2);
    }

    public void setBorderColour(int borderColour) {
        this.borderColour = borderColour;
    }

    public int getBorderColour() {
        return this.borderColour;
    }

    public EditBox getField() {
        return this.field;
    }

    @Override
    public void updateNarration(NarrationElementOutput output) {
        this.field.updateNarration(output);
    }

    @Override
    public NarratableEntry.NarrationPriority narrationPriority() {
        return this.field.narrationPriority();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        super.setVisible(visible);
        this.field.setFocused(false);
    }

    public void setColor(int color) {
        this.field.setTextColor(this.enabled ? color : DISABLED_COLOR);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setColor(ENABLED_COLOR);
    }

    @Override
    public void setFocused(boolean bl) {
        this.field.setFocused(bl);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isFocused() {
        return this.isEnabled() && this.field.isFocused();
    }

    public static enum HintType {
        ANY,
        INT,
        POSITIVE_INT,
        FLOAT,
        POSITIVE_FLOAT,
        HEX_COLOR,
        FOLDER_PATH,
        IP,
        SEARCH,
        NAME;

        private final Component hint = FiguraText.of("gui.text_hint." + this.name().toLowerCase(Locale.US));
    }
}

