/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.TextField;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;

public class SearchBar
extends TextField {
    public static final ResourceLocation CLEAR_TEXTURE = new FiguraIdentifier("textures/gui/search_clear.png");
    public static final Component SEARCH_ICON = Component.literal((String)"\ud83d\udd0e").withStyle(Style.EMPTY.withFont(UIHelper.UI_FONT).applyFormats(new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
    private final Button clearButton = new Button(this.getX() + this.getWidth() - 18, this.getY() + (this.getHeight() - 16) / 2, 16, 16, 0, 0, 16, CLEAR_TEXTURE, 48, 16, (Component)FiguraText.of("gui.clear"), button -> {
        this.getField().setValue("");
        this.setFocused(false);
    });

    public SearchBar(int x, int y, int width, int height, Consumer<String> changedListener) {
        super(x, y, width, height, TextField.HintType.SEARCH, changedListener);
        this.children.add(this.clearButton);
        this.getField().setWidth(this.getField().getWidth() - 16);
    }

    @Override
    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        this.clearButton.setVisible(!this.getField().getValue().isEmpty());
        super.render(gui, mouseX, mouseY, delta);
    }

    @Override
    protected void renderHint(GuiGraphics gui) {
        super.renderHint(gui);
        Font font = Minecraft.getInstance().font;
        int n = this.getX() + this.getWidth() - font.width((FormattedText)SEARCH_ICON) - 4;
        int n2 = this.getY();
        int n3 = this.getHeight();
        Objects.requireNonNull(font);
        gui.drawString(font, SEARCH_ICON, n, n2 + (int)((float)(n3 - 9 + 1) / 2.0f), 0xFFFFFF);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return (!this.clearButton.isVisible() || !this.clearButton.mouseClicked(mouseX, mouseY, button)) && super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return (!this.clearButton.isVisible() || !this.clearButton.isMouseOver(mouseX, mouseY)) && super.isMouseOver(mouseX, mouseY);
    }
}

