/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.gui.screens.AvatarScreen;
import org.figuramc.figura.gui.widgets.AbstractContainerElement;
import org.figuramc.figura.gui.widgets.SwitchButton;
import org.figuramc.figura.model.rendering.EntityRenderMode;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;
import org.joml.Vector3f;

public class EntityPreview
extends AbstractContainerElement {
    public static final ResourceLocation UNKNOWN = new FiguraIdentifier("textures/gui/unknown_entity.png");
    public static final ResourceLocation OVERLAY = new FiguraIdentifier("textures/gui/entity_overlay.png");
    private LivingEntity entity;
    private final float pitch;
    private final float yaw;
    private final float scale;
    private SwitchButton button;
    private boolean isRotating = false;
    private float anchorX = 0.0f;
    private float anchorY = 0.0f;
    private float anchorAngleX = 0.0f;
    private float anchorAngleY = 0.0f;
    private float angleX;
    private float angleY;
    private float scaledValue = 0.0f;
    private float scaledPrecise = 0.0f;
    private static final float SCALE_FACTOR = 1.1f;
    private boolean isDragging = false;
    private int modelX;
    private int modelY;
    private float dragDeltaX;
    private float dragDeltaY;
    private float dragAnchorX;
    private float dragAnchorY;

    public EntityPreview(int x, int y, int width, int height, float scale, float pitch, float yaw, LivingEntity entity, Screen parentScreen) {
        super(x, y, width, height);
        this.scale = scale;
        this.pitch = pitch;
        this.yaw = yaw;
        this.entity = entity;
        this.modelX = width / 2;
        this.modelY = height / 2;
        this.angleX = pitch;
        this.angleY = yaw;
        this.button = new SwitchButton(x + 4, y + 4, 16, 16, 0, 0, 16, new FiguraIdentifier("textures/gui/expand.png"), 48, 32, (Component)FiguraText.of("gui.expand"), bx -> {
            if (this.button.isToggled()) {
                Minecraft.getInstance().setScreen((Screen)new AvatarScreen(scale, pitch, yaw, this.entity, parentScreen));
            } else {
                Minecraft.getInstance().setScreen(parentScreen);
            }
        });
        this.children.add(this.button);
    }

    @Override
    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        if (!this.button.isToggled()) {
            UIHelper.blitSliced(gui, x, y, width, height, UIHelper.OUTLINE_FILL);
            UIHelper.blit(gui, x + 1, y + 1, width - 2, height, OVERLAY);
        }
        gui.enableScissor(x + 1, y + 1, x + width - 1, y + height - 1);
        PoseStack pose = gui.pose();
        if (this.entity != null) {
            pose.pushPose();
            this.scaledValue = Mth.lerp((float)((float)(1.0 - Math.pow(0.5, delta))), (float)this.scaledValue, (float)this.scaledPrecise);
            UIHelper.drawEntity(x + this.modelX, y + this.modelY, this.scale + this.scaledValue, this.angleX, this.angleY, this.entity, gui, new Vector3f(), EntityRenderMode.FIGURA_GUI);
            pose.popPose();
        } else {
            int s = Math.min(width, height) * 2 / 3;
            UIHelper.enableBlend();
            gui.blit(UNKNOWN, x + (width - s) / 2, y + (height - s) / 2, s, s, 0.0f, (float)(64 * ((int)((float)FiguraMod.ticks / 3.0f) % 8)), 64, 64, 64, 512);
        }
        gui.disableScissor();
        super.render(gui, mouseX, mouseY, delta);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isVisible() || !this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        switch (button) {
            case 0: {
                this.anchorX = (float)mouseX;
                this.anchorY = (float)mouseY;
                this.anchorAngleX = this.angleX;
                this.anchorAngleY = this.angleY;
                this.isRotating = true;
                return true;
            }
            case 1: {
                this.dragDeltaX = (float)mouseX;
                this.dragDeltaY = (float)mouseY;
                this.dragAnchorX = this.modelX;
                this.dragAnchorY = this.modelY;
                this.isDragging = true;
                return true;
            }
            case 2: {
                this.isRotating = false;
                this.isDragging = false;
                this.anchorX = 0.0f;
                this.anchorY = 0.0f;
                this.anchorAngleX = 0.0f;
                this.anchorAngleY = 0.0f;
                this.angleX = this.pitch;
                this.angleY = this.yaw;
                this.scaledValue = 0.0f;
                this.scaledPrecise = 0.0f;
                this.modelX = this.getWidth() / 2;
                this.modelY = this.getHeight() / 2;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isRotating = false;
            return true;
        }
        if (button == 1) {
            this.isDragging = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isRotating) {
            this.angleX = (float)((double)this.anchorAngleX + ((double)this.anchorY - mouseY) / (3.0 / Minecraft.getInstance().getWindow().getGuiScale()));
            this.angleY = (float)((double)this.anchorAngleY - ((double)this.anchorX - mouseX) / (3.0 / Minecraft.getInstance().getWindow().getGuiScale()));
            if (this.angleX >= 360.0f || this.angleX <= -360.0f) {
                this.anchorY = (float)mouseY;
                this.anchorAngleX = 0.0f;
                this.angleX = 0.0f;
            }
            if (this.angleY >= 360.0f || this.angleY <= -360.0f) {
                this.anchorX = (float)mouseX;
                this.anchorAngleY = 0.0f;
                this.angleY = 0.0f;
            }
            return true;
        }
        if (this.isDragging) {
            float x = (float)(mouseX - (double)this.dragDeltaX);
            float y = (float)(mouseY - (double)this.dragDeltaY);
            this.modelX = (int)(this.dragAnchorX + x);
            this.modelY = (int)(this.dragAnchorY + y);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount, double d) {
        if (!this.isVisible()) {
            return false;
        }
        if (super.mouseScrolled(mouseX, mouseY, amount, d)) {
            return true;
        }
        float scaleDir = amount + d > 0.0 ? 1.1f : 0.9090909f;
        this.scaledPrecise = (this.scale + this.scaledPrecise) * scaleDir - this.scale;
        return true;
    }

    public void setEntity(LivingEntity entity) {
        this.entity = entity;
    }

    public void setToggled(boolean toggled) {
        this.button.setToggled(toggled);
        this.button.setTooltip((Component)(toggled ? FiguraText.of("gui.minimise") : FiguraText.of("gui.expand")));
    }
}

