/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.font.Emojis;
import org.figuramc.figura.gui.widgets.FiguraTickable;
import org.figuramc.figura.gui.widgets.FiguraWidget;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.MathUtils;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class AvatarInfoWidget
implements FiguraWidget,
FiguraTickable,
GuiEventListener {
    private static final MutableComponent UNKNOWN = Component.literal((String)"?").setStyle(ColorUtils.Colors.AWESOME_BLUE.style);
    private static final MutableComponent ELLIPSIS = TextUtils.ELLIPSIS.copy().setStyle(ColorUtils.Colors.AWESOME_BLUE.style);
    private static final List<Component> TITLES = List.of(FiguraText.of("gui.name").withStyle(ChatFormatting.UNDERLINE), FiguraText.of("gui.authors").withStyle(ChatFormatting.UNDERLINE), FiguraText.of("gui.size").withStyle(ChatFormatting.UNDERLINE), FiguraText.of("gui.complexity").withStyle(ChatFormatting.UNDERLINE));
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean visible = true;
    private final int maxSize;
    private final Font font;
    private final List<Component> values = new ArrayList<Component>(){
        {
            for (Component ignored : TITLES) {
                this.add(UNKNOWN);
            }
        }
    };

    public AvatarInfoWidget(int x, int y, int width, int maxSize) {
        this.x = x;
        this.y = y;
        this.font = Minecraft.getInstance().font;
        this.width = width;
        Objects.requireNonNull(this.font);
        this.height = (9 + 4) * TITLES.size() * 2 + 4;
        this.maxSize = maxSize;
    }

    @Override
    public void tick() {
        if (!this.visible) {
            return;
        }
        Style accent = FiguraMod.getAccentColor();
        ELLIPSIS.setStyle(accent);
        UNKNOWN.setStyle(accent);
        Avatar avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
        if (avatar != null && avatar.nbt != null) {
            this.values.set(0, (Component)(avatar.name == null || avatar.name.isBlank() ? UNKNOWN : Emojis.applyEmojis((Component)Component.literal((String)avatar.name).setStyle(accent))));
            this.values.set(1, (Component)(avatar.authors == null || avatar.authors.isBlank() ? UNKNOWN : Emojis.applyEmojis((Component)Component.literal((String)avatar.authors).setStyle(accent))));
            this.values.set(2, (Component)Component.literal((String)MathUtils.asFileSize(avatar.fileSize)).setStyle(accent));
            this.values.set(3, (Component)Component.literal((String)String.valueOf(avatar.complexity.pre)).setStyle(accent));
        } else {
            for (int i = 0; i < TITLES.size(); ++i) {
                this.values.set(i, (Component)UNKNOWN);
            }
        }
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        int x = this.x + this.width / 2;
        int y = this.y + 4;
        Objects.requireNonNull(this.font);
        int height = 9 + 4;
        int maxLines = (this.maxSize - 8) / height;
        int authorFreeLines = maxLines - 7;
        Component authors = this.values.get(1);
        List authorLines = authors == null ? Collections.emptyList() : TextUtils.splitText((FormattedText)authors, "\n");
        int authorUsedLines = Math.min(authorLines.size(), authorFreeLines);
        int newHeight = height * TITLES.size() * 2 + 4 + height * (authorUsedLines - 1);
        this.height = Math.min(newHeight + height, this.maxSize);
        y += (this.height - newHeight) / 2;
        UIHelper.blitSliced(gui, this.x, this.y, this.width, this.height, UIHelper.OUTLINE_FILL);
        for (int i = 0; i < TITLES.size(); ++i) {
            Component title = TITLES.get(i);
            if (title != null) {
                gui.drawCenteredString(this.font, title, x, y, 0xFFFFFF);
            }
            y += height;
            Component value = this.values.get(i);
            if (value == null) {
                y += height;
                continue;
            }
            if (i != 1) {
                Component toRender = TextUtils.trimToWidthEllipsis(this.font, value, this.width - 10, (Component)ELLIPSIS);
                gui.drawCenteredString(this.font, toRender, x, y, 0xFFFFFF);
                if (value != toRender && UIHelper.isMouseOver(this.x, y - height, this.width, height * 2 - 4, mouseX, mouseY)) {
                    UIHelper.setTooltip(value);
                }
                y += height;
                continue;
            }
            for (int j = 0; j < authorUsedLines; ++j) {
                Component text = (Component)authorLines.get(j);
                Component newText = TextUtils.trimToWidthEllipsis(this.font, text, this.width - 10, (Component)ELLIPSIS);
                if (j == authorUsedLines - 1 && authorLines.size() > authorUsedLines) {
                    text = value;
                    newText = ELLIPSIS;
                }
                if (text != newText && UIHelper.isMouseOver(this.x, y, this.width, height, mouseX, mouseY)) {
                    UIHelper.setTooltip(text);
                }
                gui.drawCenteredString(this.font, newText, x, y, 0xFFFFFF);
                y += height;
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setFocused(boolean bl) {
    }

    public boolean isFocused() {
        return false;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }
}

