/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.figuramc.figura.gui.widgets.FiguraTickable;
import org.figuramc.figura.gui.widgets.FiguraWidget;
import org.figuramc.figura.utils.ui.UIHelper;

public abstract class AbstractContainerElement
extends AbstractContainerEventHandler
implements FiguraTickable,
FiguraWidget,
NarratableEntry {
    public static final Component HOVERED_ARROW = Component.literal((String)"\u2022");
    protected final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean hovered = false;
    private boolean visible = true;

    public AbstractContainerElement(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public void tick() {
        for (GuiEventListener listener : this.children) {
            if (!(listener instanceof FiguraTickable)) continue;
            FiguraTickable tickable = (FiguraTickable)listener;
            tickable.tick();
        }
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        for (GuiEventListener listener : this.children) {
            if (!(listener instanceof Renderable)) continue;
            Renderable widget = (Renderable)listener;
            widget.render(gui, mouseX, mouseY, delta);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        GuiEventListener widget = null;
        for (GuiEventListener guiEventListener : List.copyOf(this.children())) {
            boolean clicked = guiEventListener.mouseClicked(mouseX, mouseY, button);
            guiEventListener.setFocused(clicked);
            if (!clicked) continue;
            widget = guiEventListener;
        }
        if (this.getFocused() != widget) {
            this.setFocused(widget);
        }
        if (widget != null) {
            if (button == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return UIHelper.isMouseOver(this.getX(), this.getY(), this.getWidth(), this.getHeight(), mouseX, mouseY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.getFocused() != null && this.getFocused().mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean bool;
        boolean bl = bool = this.getFocused() != null && this.getFocused().mouseReleased(mouseX, mouseY, button);
        if (bool) {
            this.setFocused(null);
        }
        this.setDragging(false);
        return bool;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount, double d) {
        boolean ret = false;
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.isMouseOver(mouseX, mouseY)) continue;
            ret = ret || guiEventListener.mouseScrolled(mouseX, mouseY, amount, d);
        }
        return ret;
    }

    public void setHovered(boolean hovered) {
        this.hovered = hovered;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        for (GuiEventListener listener : this.children) {
            if (listener instanceof FiguraWidget) {
                FiguraWidget drawable = (FiguraWidget)listener;
                drawable.setVisible(visible);
                continue;
            }
            if (!(listener instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)listener;
            widget.visible = visible;
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    public void setFocused(boolean focused) {
        if (!focused) {
            this.setFocused(null);
        }
        super.setFocused(focused);
    }

    public void updateNarration(NarrationElementOutput output) {
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }
}

