/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.EntityPreview;
import org.figuramc.figura.gui.widgets.SliderWidget;
import org.figuramc.figura.gui.widgets.SwitchButton;
import org.figuramc.figura.gui.widgets.lists.PermissionsList;
import org.figuramc.figura.gui.widgets.lists.PlayerList;
import org.figuramc.figura.gui.widgets.permissions.AbstractPermPackElement;
import org.figuramc.figura.gui.widgets.permissions.PlayerPermPackElement;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.MathUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class PermissionsScreen
extends AbstractPanelScreen {
    private PlayerList playerList;
    private EntityPreview entityWidget;
    private SliderWidget slider;
    private PermissionsList permissionsList;
    private SwitchButton expandButton;
    private Button reloadAll;
    private Button back;
    private Button resetButton;
    private SwitchButton precisePermissions;
    private float listYPrecise;
    private float expandYPrecise;
    private float resetYPrecise;
    private boolean expanded;
    private PlayerPermPackElement dragged = null;

    public PermissionsScreen(Screen parentScreen) {
        super(parentScreen, (Component)FiguraText.of("gui.panels.title.permissions"));
    }

    @Override
    protected void init() {
        super.init();
        int middle = this.width / 2;
        int listWidth = Math.min(middle - 6, 208);
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        int entitySize = (int)Math.min((double)(this.height - 95) - (double)lineHeight * 1.5 - (double)(FiguraMod.debugModeEnabled() ? 24 : 0), (double)listWidth);
        int modelSize = 11 * entitySize / 29;
        int entityX = Math.max(middle + (listWidth - entitySize) / 2 + 1, middle + 2);
        this.entityWidget = new EntityPreview(entityX, 28, entitySize, entitySize, modelSize, -15.0f, 30.0f, (LivingEntity)Minecraft.getInstance().player, this);
        this.slider = new SliderWidget(middle + 2, (int)((double)(this.entityWidget.getY() + this.entityWidget.getHeight()) + (double)lineHeight * 1.5 + 20.0), listWidth, 11, 1.0, 5, true){

            @Override
            public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float delta) {
                super.renderWidget(gui, mouseX, mouseY, delta);
                PermissionPack selectedPack = PermissionsScreen.this.playerList.selectedEntry.getPack();
                MutableComponent text = selectedPack.getCategoryName();
                int x = (int)((float)this.getX() + (float)this.getWidth() / 2.0f - (float)PermissionsScreen.this.font.width((FormattedText)text) * 0.75f);
                int n = this.getY() - 4;
                Objects.requireNonNull(PermissionsScreen.this.font);
                int y = n - 9 * 2;
                PoseStack pose = gui.pose();
                pose.pushPose();
                pose.translate((float)x, (float)y, 0.0f);
                pose.scale(1.5f, 1.5f, 1.0f);
                UIHelper.renderOutlineText(gui, PermissionsScreen.this.font, (Component)text, 0, 0, 0xFFFFFF, 0x202020);
                pose.popPose();
                MutableComponent info = Component.literal((String)"?").withStyle(Style.EMPTY.withFont(UIHelper.UI_FONT));
                int color = 0x404040;
                int width = PermissionsScreen.this.font.width((FormattedText)info);
                x = Math.min((int)((float)x + (float)PermissionsScreen.this.font.width((FormattedText)text) * 1.5f + (float)PermissionsScreen.this.font.width("  ")), PermissionsScreen.this.width - width);
                float f = y;
                Objects.requireNonNull(PermissionsScreen.this.font);
                y = (int)(f + 9.0f * 0.25f);
                Objects.requireNonNull(PermissionsScreen.this.font);
                if (UIHelper.isMouseOver(x, y, width, 9, mouseX, mouseY)) {
                    color = 0xFFFFFF;
                    UIHelper.setTooltip((Component)selectedPack.getCategory().info);
                }
                gui.drawString(PermissionsScreen.this.font, (Component)info, x, y, color);
            }
        };
        this.permissionsList = new PermissionsList(middle + 2, this.height, listWidth, this.height - 54);
        this.playerList = new PlayerList(middle - listWidth - 2, 28, listWidth, this.height - 32, this);
        this.addRenderableWidget((GuiEventListener)this.playerList);
        this.addRenderableWidget((GuiEventListener)this.entityWidget);
        this.addRenderableWidget((GuiEventListener)this.slider);
        int bottomButtonsWidth = (listWidth - 24) / 2 - 2;
        this.reloadAll = new Button(middle + 2, this.height - 24, bottomButtonsWidth, 20, (Component)FiguraText.of("gui.permissions.reload_all"), null, bx -> {
            AvatarManager.clearAllAvatars();
            FiguraToast.sendToast(FiguraText.of("toast.reload_all"));
        });
        this.addRenderableWidget((GuiEventListener)this.reloadAll);
        this.back = new Button(middle + 6 + bottomButtonsWidth, this.height - 24, bottomButtonsWidth, 20, (Component)FiguraText.of("gui.done"), null, bx -> this.onClose());
        this.addRenderableWidget((GuiEventListener)this.back);
        this.expandButton = new SwitchButton(middle + listWidth - 18, this.height - 24, 20, 20, 0, 0, 20, new FiguraIdentifier("textures/gui/expand_v.png"), 60, 40, (Component)FiguraText.of("gui.permissions.expand_permissions.tooltip"), btn -> {
            this.expanded = this.expandButton.isToggled();
            this.entityWidget.setVisible(!this.expanded);
            this.slider.setVisible(!this.expanded);
            this.slider.setActive(!this.expanded);
            this.reloadAll.setVisible(!this.expanded);
            this.back.setVisible(!this.expanded);
            this.expandButton.setTooltip((Component)(this.expanded ? FiguraText.of("gui.permissions.minimize_permissions.tooltip") : FiguraText.of("gui.permissions.expand_permissions.tooltip")));
            this.resetButton.setActive(this.expanded);
        });
        this.addRenderableWidget((GuiEventListener)this.expandButton);
        this.resetButton = new Button(middle + 2, this.height, 60, 20, (Component)FiguraText.of("gui.permissions.reset"), null, btn -> {
            PermissionPack pack = this.playerList.selectedEntry.getPack();
            pack.clear();
            this.updatePermissions(pack);
        });
        this.addRenderableWidget((GuiEventListener)this.resetButton);
        this.precisePermissions = new SwitchButton(middle + 66, this.height, listWidth - 88, 20, (Component)FiguraText.of("gui.permissions.precise"), false){

            @Override
            public void onPress() {
                super.onPress();
                PermissionsScreen.this.permissionsList.precise = this.isToggled();
                PermissionsScreen.this.permissionsList.updateList(PermissionsScreen.this.playerList.selectedEntry.getPack());
            }
        };
        this.addRenderableWidget((GuiEventListener)this.precisePermissions);
        this.precisePermissions.setUnderline(false);
        this.addRenderableWidget((GuiEventListener)this.permissionsList);
        this.listYPrecise = this.permissionsList.getY();
        this.expandYPrecise = this.expandButton.getY();
        this.resetYPrecise = this.resetButton.getY();
    }

    @Override
    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        AbstractPermPackElement entity = this.playerList.selectedEntry;
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null && entity instanceof PlayerPermPackElement) {
            PlayerPermPackElement player = (PlayerPermPackElement)entity;
            this.entityWidget.setEntity((LivingEntity)world.getPlayerByUUID(UUID.fromString(player.getPack().name)));
        } else {
            this.entityWidget.setEntity(null);
        }
        float lerpDelta = MathUtils.magicDelta(0.6f, delta);
        this.listYPrecise = Mth.lerp((float)lerpDelta, (float)this.listYPrecise, (float)(this.expandButton.isToggled() ? 50.0f : (float)(this.height + 1)));
        this.permissionsList.setY((int)this.listYPrecise);
        this.expandYPrecise = Mth.lerp((float)lerpDelta, (float)this.expandYPrecise, (float)(this.expandButton.isToggled() ? this.listYPrecise - 22.0f : this.listYPrecise - 24.0f));
        this.expandButton.setY((int)this.expandYPrecise);
        this.resetYPrecise = Mth.lerp((float)lerpDelta, (float)this.resetYPrecise, (float)(this.expandButton.isToggled() ? this.listYPrecise - 22.0f : (float)this.height));
        this.resetButton.setY((int)this.resetYPrecise);
        this.precisePermissions.setY((int)this.resetYPrecise);
        super.render(gui, mouseX, mouseY, delta);
    }

    @Override
    public void renderOverlays(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (this.dragged != null && this.dragged.dragged) {
            this.dragged.renderDragged(gui, mouseX, mouseY, delta);
        }
        super.renderOverlays(gui, mouseX, mouseY, delta);
    }

    public void removed() {
        PermissionManager.saveToDisk();
        super.removed();
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.expandButton.isToggled()) {
            this.expandButton.onPress();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        PlayerPermPackElement element;
        AbstractPermPackElement abstractPermPackElement;
        boolean bool = super.mouseClicked(mouseX, mouseY, button);
        this.dragged = null;
        if (button == 0 && (abstractPermPackElement = this.playerList.selectedEntry) instanceof PlayerPermPackElement && (element = (PlayerPermPackElement)abstractPermPackElement).isMouseOver(mouseX, mouseY)) {
            this.dragged = element;
            element.anchorX = (int)mouseX;
            element.anchorY = (int)mouseY;
            element.initialY = element.getY();
        }
        return bool;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragged != null) {
            this.dragged.index = this.playerList.getCategoryAt(mouseY);
            this.dragged.dragged = true;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean bool = super.mouseReleased(mouseX, mouseY, button);
        if (this.dragged == null || !this.dragged.dragged) {
            return bool;
        }
        PermissionPack pack = this.dragged.getPack();
        Permissions.Category category = Permissions.Category.indexOf(Math.min(this.dragged.index, Permissions.Category.values().length - 1));
        pack.setCategory(PermissionManager.CATEGORIES.get((Object)category));
        this.updatePermissions(pack);
        this.dragged.dragged = false;
        this.dragged = null;
        return bool;
    }

    public void updatePermissions(PermissionPack pack) {
        this.slider.setAction(null);
        this.slider.setActive(pack instanceof PermissionPack.PlayerPermissionPack && !this.expanded);
        this.slider.setMax(Permissions.Category.values().length);
        this.slider.setScrollProgress((double)pack.getCategory().index / ((double)this.slider.getMax() - 1.0));
        this.slider.setAction(scroll -> {
            Permissions.Category category = Permissions.Category.indexOf(((SliderWidget)scroll).getIntValue());
            pack.setCategory(PermissionManager.CATEGORIES.get((Object)category));
            this.permissionsList.updateList(pack);
        });
        this.permissionsList.updateList(pack);
    }
}

