/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.screens.DocsScreen;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.IconButton;
import org.figuramc.figura.gui.widgets.Label;
import org.figuramc.figura.gui.widgets.ParticleWidget;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class HelpScreen
extends AbstractPanelScreen {
    public static final ResourceLocation ICONS = new FiguraIdentifier("textures/gui/help_icons.png");
    public static final String LUA_VERSION = "5.2 - Figura";
    private IconButton kofi;

    public HelpScreen(Screen parentScreen) {
        super(parentScreen, (Component)FiguraText.of("gui.panels.title.help"));
    }

    @Override
    protected void init() {
        super.init();
        Objects.requireNonNull(this.minecraft.font);
        int lineHeight = 9;
        int middle = this.width / 2;
        int labelWidth = Math.min(this.width - 8, 420);
        int y = 28;
        Style color = FiguraMod.getAccentColor();
        this.addRenderableWidget(new Title((Object)FiguraText.of("gui.help.docs").withStyle(color), middle, y, labelWidth));
        IconButton docs = new IconButton(middle - 60, y += lineHeight + 4, 120, 24, 20, 0, 20, ICONS, 60, 40, (Component)FiguraText.of("gui.help.ingame_docs"), null, button -> this.minecraft.setScreen((Screen)new DocsScreen(this)));
        this.addRenderableWidget((GuiEventListener)docs);
        docs.setActive(false);
        this.addRenderableWidget((GuiEventListener)new IconButton(middle - 60, y += 28, 120, 24, 0, 0, 20, ICONS, 60, 40, (Component)FiguraText.of("gui.help.lua_manual"), null, bx -> UIHelper.openURL(FiguraMod.Links.LuaManual.url).run()));
        this.addRenderableWidget((GuiEventListener)new IconButton(middle - 60, y += 28, 120, 24, 40, 0, 20, ICONS, 60, 40, (Component)FiguraText.of("gui.help.external_wiki"), null, bx -> UIHelper.openURL(FiguraMod.Links.Wiki.url).run()));
        this.addRenderableWidget(new Title((Object)FiguraText.of("gui.help.links").withStyle(color), middle, y += 28, labelWidth));
        this.addRenderableWidget((GuiEventListener)new IconButton(middle - 124, y += lineHeight + 4, 80, 24, 0, 20, 20, ICONS, 60, 40, (Component)Component.literal((String)"Discord"), null, bx -> UIHelper.openURL(FiguraMod.Links.Discord.url).run()));
        this.addRenderableWidget((GuiEventListener)new IconButton(middle - 40, y, 80, 24, 20, 20, 20, ICONS, 60, 40, (Component)Component.literal((String)"GitHub"), null, bx -> UIHelper.openURL(FiguraMod.Links.Github.url).run()){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (((Boolean)Configs.EASTER_EGGS.value).booleanValue() && this.isHoveredOrFocused() && this.isMouseOver(mouseX, mouseY) && button == 1) {
                    int dim = this.getTextureSize();
                    int x = (int)(Math.random() * (double)dim) + this.getX() + 2;
                    int y = (int)(Math.random() * (double)dim) + this.getY() + 2;
                    HelpScreen.this.addRenderableOnly(new ParticleWidget(x, y, (ParticleType<?>)ParticleTypes.HEART));
                    boolean purr = Math.random() < 0.95;
                    HelpScreen.this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)(purr ? SoundEvents.CAT_PURR : SoundEvents.CAT_AMBIENT), (float)1.0f));
                    return false;
                }
                return super.mouseClicked(mouseX, mouseY, button);
            }
        });
        this.kofi = new IconButton(middle + 44, y, 80, 24, 40, 20, 20, ICONS, 60, 40, (Component)Component.literal((String)"Ko-fi"), null, b -> UIHelper.openURL(FiguraMod.Links.Kofi.url).run());
        this.addRenderableWidget((GuiEventListener)this.kofi);
        this.addRenderableWidget(new Title((Object)FiguraText.of("gui.help.about").withStyle(color), middle, y += 28, labelWidth));
        this.addRenderableWidget(new Label((Object)FiguraText.of("gui.help.lua_version", Component.literal((String)LUA_VERSION).withStyle(color)), middle, y += lineHeight + 4, TextUtils.Alignment.CENTER));
        this.addRenderableWidget(new Label((Object)FiguraText.of("gui.help.figura_version", Component.literal((String)FiguraMod.VERSION.toString()).withStyle(color)), middle, y += lineHeight + 4, TextUtils.Alignment.CENTER));
        this.addRenderableWidget((GuiEventListener)new Button(middle - 60, this.height - 24, 120, 20, (Component)FiguraText.of("gui.done"), null, bx -> this.onClose()));
    }

    @Override
    public void tick() {
        super.tick();
        if (FiguraMod.ticks % 5 == 0 && this.kofi.isHoveredOrFocused()) {
            int x = (int)(Math.random() * (double)this.kofi.getWidth()) + this.kofi.getX();
            int y = (int)(Math.random() * (double)this.kofi.getHeight()) + this.kofi.getY();
            this.addRenderableOnly(new ParticleWidget(x, y, (ParticleType<?>)ParticleTypes.HAPPY_VILLAGER));
        }
    }

    private static class Title
    extends Label {
        private final int width;

        public Title(Object text, int x, int y, int width) {
            super(text, x, y, TextUtils.Alignment.CENTER);
            this.width = width;
        }

        @Override
        public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            int x = this.getRawX();
            int y = this.getRawY();
            int y0 = y + this.getHeight() / 2;
            int y1 = y0 + 1;
            int x0 = x - this.width / 2;
            int x1 = x - this.getWidth() / 2 - 4;
            gui.fill(x0, y0, x1, y1, -1);
            x0 = x + this.getWidth() / 2 + 4;
            x1 = x + this.width / 2;
            gui.fill(x0, y0, x1, y1, -1);
            super.render(gui, mouseX, mouseY, delta);
        }
    }
}

