/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import org.figuramc.figura.config.ConfigManager;
import org.figuramc.figura.config.ConfigType;
import org.figuramc.figura.gui.PaperDoll;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.Label;
import org.figuramc.figura.gui.widgets.SearchBar;
import org.figuramc.figura.gui.widgets.lists.ConfigList;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.IOUtils;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class ConfigScreen
extends AbstractPanelScreen {
    public static final Map<ConfigType.Category, Boolean> CATEGORY_DATA = new HashMap<ConfigType.Category, Boolean>();
    private ConfigList list;
    private Button cancel;
    private final boolean hasPanels;
    public boolean renderPaperdoll;

    public ConfigScreen(Screen parentScreen) {
        this(parentScreen, true);
    }

    public ConfigScreen(Screen parentScreen, boolean enablePanels) {
        super(parentScreen, (Component)FiguraText.of("gui.panels.title.settings"));
        this.hasPanels = enablePanels;
    }

    @Override
    protected void init() {
        super.init();
        ConfigScreen.loadNbt();
        if (!this.hasPanels) {
            this.removeWidget((GuiEventListener)this.panels);
            Label l = new Label((Object)this.getTitle(), this.width / 2, 14, TextUtils.Alignment.CENTER);
            this.addRenderableWidget(l);
            l.centerVertically = true;
        }
        int width = Math.min(this.width - 8, 420);
        this.list = new ConfigList((this.width - width) / 2, 52, width, this.height - 80, this);
        this.addRenderableWidget((GuiEventListener)new SearchBar(this.width / 2 - 122, 28, 244, 20, query -> this.list.updateSearch(query.toLowerCase(Locale.US))));
        this.addRenderableWidget((GuiEventListener)this.list);
        this.cancel = new Button(this.width / 2 - 122, this.height - 24, 120, 20, (Component)FiguraText.of("gui.cancel"), null, button -> {
            ConfigManager.discardConfig();
            this.list.updateList();
        });
        this.addRenderableWidget((GuiEventListener)this.cancel);
        this.cancel.setActive(false);
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 + 2, this.height - 24, 120, 20, (Component)FiguraText.of("gui.done"), null, button -> this.onClose()));
    }

    @Override
    public void tick() {
        super.tick();
        this.cancel.setActive(this.list.hasChanges());
    }

    public void removed() {
        ConfigManager.applyConfig();
        ConfigManager.saveConfig();
        ConfigScreen.saveNbt();
        super.removed();
    }

    @Override
    public void renderOverlays(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        super.renderOverlays(gui, mouseX, mouseY, delta);
        if (this.renderPaperdoll) {
            UIHelper.renderWithoutScissors(gui, g -> PaperDoll.render(g, true));
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.list.updateKey(InputConstants.Type.MOUSE.getOrCreate(button)) || super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.list.updateKey(keyCode == 256 ? InputConstants.UNKNOWN : InputConstants.getKey((int)keyCode, (int)scanCode)) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    private static void loadNbt() {
        IOUtils.readCacheFile("settings", nbt -> {
            ListTag groupList = nbt.getList("settings", 10);
            for (Tag tag : groupList) {
                CompoundTag compound = (CompoundTag)tag;
                String config = compound.getString("config");
                boolean expanded = compound.getBoolean("expanded");
                CATEGORY_DATA.put(ConfigManager.CATEGORIES_REGISTRY.get(config), expanded);
            }
        });
    }

    private static void saveNbt() {
        IOUtils.saveCacheFile("settings", nbt -> {
            ListTag list = new ListTag();
            for (Map.Entry<ConfigType.Category, Boolean> entry : CATEGORY_DATA.entrySet()) {
                CompoundTag compound = new CompoundTag();
                compound.putString("config", entry.getKey().id);
                compound.putBoolean("expanded", entry.getValue().booleanValue());
                list.add((Object)compound);
            }
            nbt.put("settings", (Tag)list);
        });
    }

    public static void clearCache() {
        IOUtils.deleteCacheFile("settings");
    }
}

