/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.lists.AvatarWizardList;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.wizards.AvatarWizard;

public class AvatarWizardScreen
extends AbstractPanelScreen {
    private final Screen sourcePanel;
    private final AvatarWizard wizard = new AvatarWizard();
    private Button build;

    public AvatarWizardScreen(AbstractPanelScreen parentScreen) {
        super(parentScreen.parentScreen, (Component)FiguraText.of("gui.panels.title.avatar_wizard"));
        this.sourcePanel = parentScreen;
    }

    @Override
    public Class<? extends Screen> getSelectedPanel() {
        return this.sourcePanel.getClass();
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 122, this.height - 24, 120, 20, (Component)FiguraText.of("gui.cancel"), null, button -> this.onClose()));
        this.build = new Button(this.width / 2 + 4, this.height - 24, 120, 20, (Component)FiguraText.of("gui.create"), null, button -> {
            try {
                this.wizard.build();
                FiguraToast.sendToast(FiguraText.of("toast.avatar_wizard.success"));
            }
            catch (Exception e) {
                FiguraToast.sendToast((Object)FiguraText.of("toast.avatar_wizard.error"), FiguraToast.ToastType.ERROR);
                FiguraMod.LOGGER.error("", (Throwable)e);
            }
            this.onClose();
        });
        this.addRenderableWidget((GuiEventListener)this.build);
        int width = Math.min(this.width - 8, 420) / 2;
        this.addRenderableWidget((GuiEventListener)new AvatarWizardList((this.width - width) / 2, 28, width, this.height - 56, this.wizard));
    }

    @Override
    public void onClose() {
        this.minecraft.setScreen(this.sourcePanel);
    }

    @Override
    public void tick() {
        super.tick();
        this.build.setActive(this.wizard.canBuild());
    }
}

