/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.Badges;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.MathUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class PopupMenu {
    private static final FiguraIdentifier BACKGROUND = new FiguraIdentifier("textures/gui/popup.png");
    private static final FiguraIdentifier ICONS = new FiguraIdentifier("textures/gui/popup_icons.png");
    private static final MutableComponent VERSION_WARN = Component.empty().append((Component)Badges.System.WARNING.badge.copy().withStyle(Style.EMPTY.withFont(Badges.FONT))).append(" ").append((Component)Badges.System.WARNING.desc.copy().withStyle(ChatFormatting.YELLOW));
    private static final MutableComponent ERROR_WARN = Component.empty().append((Component)Badges.System.ERROR.badge.copy().withStyle(Style.EMPTY.withFont(Badges.FONT))).append(" ").append((Component)Badges.System.ERROR.desc.copy().withStyle(ChatFormatting.RED));
    private static final MutableComponent PERMISSION_WARN = Component.empty().append((Component)Badges.System.PERMISSIONS.badge.copy().withStyle(Style.EMPTY.withFont(Badges.FONT))).append(" ").append((Component)Badges.System.PERMISSIONS.desc.copy().withStyle(ChatFormatting.BLUE));
    private static final List<Pair<Component, Consumer<UUID>>> BUTTONS = List.of(Pair.of((Object)FiguraText.of("popup_menu.cancel"), id -> {}), Pair.of((Object)FiguraText.of("popup_menu.reload"), id -> {
        AvatarManager.reloadAvatar(id);
        FiguraToast.sendToast(FiguraText.of("toast.reload"));
    }), Pair.of((Object)FiguraText.of("popup_menu.increase_permissions"), id -> {
        PermissionPack.PlayerPermissionPack pack = PermissionManager.get(id);
        if (PermissionManager.increaseCategory(pack)) {
            FiguraToast.sendToast((Object)FiguraText.of("toast.permission_change"), ((PermissionPack)pack).getCategoryName());
        }
    }), Pair.of((Object)FiguraText.of("popup_menu.decrease_permissions"), id -> {
        PermissionPack.PlayerPermissionPack pack = PermissionManager.get(id);
        if (PermissionManager.decreaseCategory(pack)) {
            FiguraToast.sendToast((Object)FiguraText.of("toast.permission_change"), ((PermissionPack)pack).getCategoryName());
        }
    }));
    private static final int LENGTH = BUTTONS.size();
    private static int index = 0;
    private static boolean enabled = false;
    private static Entity entity;
    private static UUID id;

    public static void render(GuiGraphics gui) {
        Avatar avatar;
        if (!PopupMenu.isEnabled()) {
            return;
        }
        if (entity == null) {
            id = null;
            return;
        }
        id = entity.getUUID();
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null || entity.isInvisibleTo((Player)minecraft.player) && entity != minecraft.player) {
            entity = null;
            id = null;
            return;
        }
        RenderSystem.disableDepthTest();
        PoseStack pose = gui.pose();
        pose.pushPose();
        FiguraVec3 worldPos = FiguraVec3.fromVec3(entity.getPosition(minecraft.getTimer().getGameTimeDeltaPartialTick(false)));
        worldPos.add(0.0, (double)(entity.getBbHeight() + 0.1f), 0.0);
        FiguraVec4 vec = MathUtils.worldToScreenSpace(worldPos);
        if (vec.z < 1.0) {
            return;
        }
        Window window = minecraft.getWindow();
        double w = window.getGuiScaledWidth();
        double h = window.getGuiScaledHeight();
        double s = (double)((Float)Configs.POPUP_SCALE.value).floatValue() * Math.max(Math.min((double)window.getHeight() * 0.035 / vec.w * (1.0 / window.getGuiScale()), (double)((Float)Configs.POPUP_MAX_SIZE.value).floatValue()), (double)((Float)Configs.POPUP_MIN_SIZE.value).floatValue());
        pose.translate((vec.x + 1.0) / 2.0 * w, (vec.y + 1.0) / 2.0 * h, -100.0);
        pose.scale((float)(s * 0.5), (float)(s * 0.5), 1.0f);
        int width = LENGTH * 18;
        UIHelper.enableBlend();
        int frame = (Boolean)Configs.REDUCED_MOTION.value != false ? 0 : (int)((float)FiguraMod.ticks / 5.0f % 4.0f);
        gui.blit((ResourceLocation)BACKGROUND, width / -2, -24, width, 26, 0.0f, (float)(frame * 26), width, 26, width, 104);
        pose.translate(0.0f, 0.0f, -2.0f);
        UIHelper.enableBlend();
        for (int i = 0; i < LENGTH; ++i) {
            gui.blit((ResourceLocation)ICONS, width / -2 + 18 * i, -24, 18, 18, (float)(18 * i), i == index ? 18.0f : 0.0f, 18, 18, width, 36);
        }
        Font font = minecraft.font;
        Component title = (Component)BUTTONS.get(index).getFirst();
        PermissionPack.PlayerPermissionPack tc = PermissionManager.get(id);
        MutableComponent permissionName = ((PermissionPack)tc).getCategoryName().append(tc.hasChanges() ? "*" : "");
        MutableComponent name = entity.getName().copy();
        boolean error = false;
        boolean version = false;
        boolean noPermissions = false;
        Component badges = Badges.fetchBadges(id);
        if (!badges.getString().isEmpty()) {
            name.append(" ").append(badges);
        }
        if ((avatar = AvatarManager.getAvatarForPlayer(id)) != null) {
            error = avatar.scriptError;
            version = avatar.versionStatus > 0;
            noPermissions = !avatar.noPermissions.isEmpty();
        }
        UIHelper.renderOutlineText(gui, font, (Component)name, -font.width((FormattedText)name) / 2, -36, 0xFFFFFF, 0x202020);
        pose.scale(0.5f, 0.5f, 0.5f);
        pose.translate(0.0f, 0.0f, -1.0f);
        UIHelper.renderOutlineText(gui, font, (Component)permissionName, -font.width((FormattedText)permissionName) / 2, -54, 0xFFFFFF, 0x202020);
        gui.drawString(font, title, -width + 4, -12, 0xFFFFFF);
        if (error) {
            UIHelper.renderOutlineText(gui, font, (Component)ERROR_WARN, -font.width((FormattedText)ERROR_WARN) / 2, 0, 0xFFFFFF, 0x202020);
        }
        if (version) {
            int n;
            int n2 = -font.width((FormattedText)VERSION_WARN) / 2;
            if (error) {
                Objects.requireNonNull(font);
                n = 9;
            } else {
                n = 0;
            }
            UIHelper.renderOutlineText(gui, font, (Component)VERSION_WARN, n2, n, 0xFFFFFF, 0x202020);
        }
        if (noPermissions) {
            int n;
            int n3;
            int n4 = -font.width((FormattedText)PERMISSION_WARN) / 2;
            if (error) {
                Objects.requireNonNull(font);
                n3 = 9;
            } else {
                n3 = 0;
            }
            if (version) {
                Objects.requireNonNull(font);
                n = 9;
            } else {
                n = 0;
            }
            UIHelper.renderOutlineText(gui, font, (Component)PERMISSION_WARN, n4, n3 + n, 0xFFFFFF, 0x202020);
        }
        pose.popPose();
    }

    public static void scroll(double d) {
        index = (int)((double)index - d + (double)LENGTH) % LENGTH;
    }

    public static void hotbarKeyPressed(int i) {
        if (i < LENGTH && i >= 0) {
            index = i;
        }
    }

    public static void run() {
        if (id != null) {
            ((Consumer)BUTTONS.get(index).getSecond()).accept(id);
        }
        enabled = false;
        entity = null;
        id = null;
        index = 0;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        PopupMenu.enabled = enabled;
    }

    public static boolean hasEntity() {
        return entity != null;
    }

    public static void setEntity(Entity entity) {
        PopupMenu.entity = entity;
    }

    public static UUID getEntityId() {
        return id;
    }
}

