/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.ConfigType;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.utils.PlatformUtils;

public final class ConfigManager {
    private static final File FILE = new File(PlatformUtils.getConfigDir().resolve("figura.json").toString());
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    public static final List<ConfigType<?>> REGISTRY = new ArrayList();
    public static final Map<String, ConfigType.Category> CATEGORIES_REGISTRY = new LinkedHashMap<String, ConfigType.Category>();
    private static boolean initializing = false;

    public static void init() {
        Configs.init();
        ConfigManager.loadConfig();
        ConfigManager.saveConfig();
    }

    public static void loadConfig() {
        try {
            if (FILE.exists()) {
                initializing = true;
                BufferedReader br = new BufferedReader(new FileReader(FILE));
                JsonObject json = JsonParser.parseReader((Reader)br).getAsJsonObject();
                JsonElement version = json.get("CONFIG_VERSION");
                if (version != null && version.getAsInt() != 1) {
                    ConfigManager.update(json, version.getAsInt());
                } else {
                    for (ConfigType<?> config : REGISTRY) {
                        JsonElement object = json.get(config.id.toLowerCase(Locale.US));
                        if (object == null) continue;
                        if (config instanceof ConfigType.SerializableConfig) {
                            ConfigType.SerializableConfig s = (ConfigType.SerializableConfig)((Object)config);
                            s.deserialize(object);
                            continue;
                        }
                        String obj = object.getAsString();
                        if (config instanceof ConfigType.KeybindConfig) {
                            ConfigType.KeybindConfig keybind = (ConfigType.KeybindConfig)config;
                            keybind.keyBind.setKey(InputConstants.getKey((String)obj));
                            continue;
                        }
                        if (config instanceof ConfigType.InputConfig) {
                            ConfigType.InputConfig input = (ConfigType.InputConfig)config;
                            if (!input.inputType.validator.test(obj)) continue;
                            config.setValue(obj);
                            continue;
                        }
                        config.setValue(obj);
                    }
                }
                br.close();
                FiguraMod.debug("Successfully loaded config file", new Object[0]);
            }
        }
        catch (Exception e) {
            FiguraMod.LOGGER.warn("Failed to load config file! Resetting all settings...", (Throwable)e);
            ConfigManager.setDefaults();
        }
        initializing = false;
    }

    public static void saveConfig() {
        if (initializing) {
            return;
        }
        try {
            JsonObject configJson = new JsonObject();
            configJson.addProperty("CONFIG_VERSION", (Number)1);
            for (ConfigType<?> config : REGISTRY) {
                if (config.isDefault()) continue;
                String id = config.id;
                if (config instanceof ConfigType.SerializableConfig) {
                    ConfigType.SerializableConfig s = (ConfigType.SerializableConfig)((Object)config);
                    configJson.add(id, s.serialize());
                    continue;
                }
                Object t = config.value;
                if (t instanceof Number) {
                    Number n = (Number)t;
                    configJson.addProperty(id, n);
                    continue;
                }
                t = config.value;
                if (t instanceof Character) {
                    Character c = (Character)t;
                    configJson.addProperty(id, c);
                    continue;
                }
                t = config.value;
                if (t instanceof Boolean) {
                    Boolean b = (Boolean)t;
                    configJson.addProperty(id, b);
                    continue;
                }
                if (config.value == null) continue;
                configJson.addProperty(id, String.valueOf(config.value));
            }
            String jsonString = GSON.toJson((JsonElement)configJson);
            FileWriter fileWriter = new FileWriter(FILE);
            fileWriter.write(jsonString);
            fileWriter.close();
            FiguraMod.debug("Successfully saved config file", new Object[0]);
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Failed to save config file!", (Throwable)e);
        }
    }

    public static void applyConfig() {
        for (ConfigType<?> config : REGISTRY) {
            config.setValue(String.valueOf(config.tempValue));
        }
    }

    public static void discardConfig() {
        for (ConfigType<?> config : REGISTRY) {
            config.discardConfig();
        }
    }

    public static void setDefaults() {
        for (ConfigType<?> config : REGISTRY) {
            config.setDefault();
        }
    }

    public static void update(JsonObject json, int version) {
        Map versionMap = Configs.CONFIG_UPDATES.get(version);
        if (versionMap == null) {
            return;
        }
        for (Map.Entry config : versionMap.entrySet()) {
            JsonElement object = json.get((String)config.getValue());
            if (object == null) continue;
            String jsonValue = object.getAsString();
            ((ConfigType)config.getKey()).setValue(jsonValue);
        }
        FiguraMod.debug("Config updated from version " + version, new Object[0]);
    }
}

