/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.backend2;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.backend2.HttpAPI;
import org.figuramc.figura.backend2.NetworkStuff;
import org.figuramc.figura.resources.FiguraRuntimeResources;
import org.figuramc.figura.utils.FiguraClientCommandSource;

public class BackendCommands {
    public static LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder backend = LiteralArgumentBuilder.literal((String)"backend2");
        LiteralArgumentBuilder connect = LiteralArgumentBuilder.literal((String)"connect");
        connect.executes(context -> {
            NetworkStuff.reAuth();
            return 1;
        });
        backend.then((ArgumentBuilder)connect);
        LiteralArgumentBuilder run = LiteralArgumentBuilder.literal((String)"run");
        run.executes(context -> BackendCommands.runRequest((CommandContext<FiguraClientCommandSource>)context, ""));
        RequiredArgumentBuilder request = RequiredArgumentBuilder.argument((String)"request", (ArgumentType)StringArgumentType.greedyString());
        request.executes(context -> BackendCommands.runRequest((CommandContext<FiguraClientCommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"request")));
        run.then((ArgumentBuilder)request);
        backend.then((ArgumentBuilder)run);
        LiteralArgumentBuilder debug = LiteralArgumentBuilder.literal((String)"debug");
        debug.executes(context -> {
            NetworkStuff.debug = !NetworkStuff.debug;
            FiguraMod.sendChatMessage((Component)Component.literal((String)("Backend Debug Mode set to: " + NetworkStuff.debug)).withStyle(NetworkStuff.debug ? ChatFormatting.GREEN : ChatFormatting.RED));
            return 1;
        });
        backend.then((ArgumentBuilder)debug);
        LiteralArgumentBuilder resources = LiteralArgumentBuilder.literal((String)"checkResources");
        resources.executes(context -> {
            ((FiguraClientCommandSource)context.getSource()).figura$sendFeedback((Component)Component.literal((String)"Checking for resources..."));
            FiguraRuntimeResources.init().thenRun(() -> ((FiguraClientCommandSource)context.getSource()).figura$sendFeedback((Component)Component.literal((String)"Resources checked!")));
            return 1;
        });
        backend.then((ArgumentBuilder)resources);
        return backend;
    }

    private static int runRequest(CommandContext<FiguraClientCommandSource> context, String request) {
        try {
            HttpAPI.runString(NetworkStuff.api.header(request).build(), (code, data) -> FiguraMod.sendChatMessage((Component)Component.literal((String)data)));
            return 1;
        }
        catch (Exception e) {
            ((FiguraClientCommandSource)context.getSource()).figura$sendError((Component)Component.literal((String)e.getMessage()));
            return 0;
        }
    }
}

