/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.mail;

import com.mojang.authlib.GameProfile;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.mail.IMailbox;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public record Mailbox(UUID id, ResourceKey<Level> levelKey, BlockPos pos, MutableObject<UUID> owner, MutableObject<String> customName, Queue<ItemStack> queue, MutableBoolean removed, DeliveryService service) implements IMailbox
{
    public static final int MAX_NAME_LENGTH = 32;

    public boolean rename(String customName) {
        if (!customName.isBlank() && customName.length() <= 32) {
            this.customName.setValue((Object)customName);
            this.service.setDirty();
            return true;
        }
        return false;
    }

    public boolean hasOwner() {
        return this.owner.getValue() != null;
    }

    public void setOwner(UUID uuid) {
        this.owner.setValue((Object)uuid);
        this.service.setDirty();
    }

    void tick() {
        if (this.removed.booleanValue()) {
            return;
        }
        MinecraftServer server = this.service.getServer();
        ServerLevel level = server.getLevel(this.levelKey);
        if (level == null || !level.isLoaded(this.pos)) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof MailboxBlockEntity) {
            MailboxBlockEntity blockEntity2 = (MailboxBlockEntity)blockEntity;
            if (blockEntity2.getMailbox() != this) {
                this.remove();
                return;
            }
            if (this.queue.isEmpty()) {
                return;
            }
            ItemStack stack = this.queue.peek();
            if (blockEntity2.deliverItem(stack)) {
                this.queue.remove();
                this.service.setDirty();
            }
        } else {
            this.remove();
        }
    }

    public void remove() {
        this.service.removeMailbox(this);
        this.removed.setValue(true);
    }

    public void writeQueue(CompoundTag compound, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        this.queue.forEach(stack -> {
            if (!stack.isEmpty()) {
                list.add((Object)stack.save(provider));
            }
        });
        compound.put("Queue", (Tag)list);
    }

    public static Queue<ItemStack> readQueueListTag(CompoundTag compound, HolderLookup.Provider provider) {
        if (compound.contains("Queue", 9)) {
            ArrayDeque<ItemStack> queue = new ArrayDeque<ItemStack>();
            ListTag list = compound.getList("Queue", 10);
            list.forEach(tag -> {
                ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)((CompoundTag)tag));
                if (!stack.isEmpty()) {
                    queue.offer(stack);
                }
            });
            return queue;
        }
        return new ArrayDeque<ItemStack>();
    }

    void spawnQueueIntoLevel() {
        ServerLevel level = this.service.getServer().getLevel(this.levelKey);
        if (level != null) {
            Queue<ItemStack> queue = this.queue;
            while (!queue.isEmpty()) {
                ItemStack stack = queue.poll();
                Containers.dropItemStack((Level)level, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), (ItemStack)stack);
            }
        }
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Mailbox mailbox = (Mailbox)obj;
        return this.id.equals(mailbox.id);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Optional<GameProfile> getOwner() {
        GameProfileCache cache;
        UUID ownerId = (UUID)this.owner.getValue();
        if (ownerId != null && (cache = this.service.getServer().getProfileCache()) != null) {
            return cache.get(ownerId);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getCustomName() {
        return Optional.ofNullable((String)this.customName.getValue());
    }
}

