/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.model.obj.lod;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import team.lodestar.lodestone.systems.model.obj.lod.LODBuilder;
import team.lodestar.lodestone.systems.model.obj.lod.LevelOfDetail;

public abstract class LODStrategy<T>
implements LODBuilder<T> {
    public List<LevelOfDetail<T>> levelsOfDetail = new ArrayList<LevelOfDetail<T>>();

    public LODStrategy(Consumer<LODBuilder<T>> lodBuilderSetup) {
        lodBuilderSetup.accept(this);
    }

    public abstract LevelOfDetail<T> getLODLevel(PoseStack var1);

    public LevelOfDetail<T> getDefaultLOD() {
        return this.levelsOfDetail.get(this.levelsOfDetail.size() - 1);
    }

    public static LODStrategy<Float> Distance(Consumer<LODBuilder<Float>> lodBuilder) {
        return new DistanceLODStrategy(lodBuilder);
    }

    public static LODStrategy<GraphicsStatus> Graphics(Consumer<LODBuilder<GraphicsStatus>> lodBuilder) {
        return new GraphicsSettingsLODStrategy(lodBuilder);
    }

    private static class DistanceLODStrategy
    extends LODStrategy<Float> {
        public DistanceLODStrategy(Consumer<LODBuilder<Float>> lodBuilder) {
            super(lodBuilder);
        }

        @Override
        public LevelOfDetail<Float> getLODLevel(PoseStack poseStack) {
            Vector3f cameraPosition = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
            float distanceSq = cameraPosition.distanceSquared((Vector3fc)this.getPositionFromPose(poseStack));
            for (LevelOfDetail levelOfDetail : this.levelsOfDetail) {
                if (!(distanceSq <= ((Float)levelOfDetail.getArgument()).floatValue())) continue;
                return levelOfDetail;
            }
            return this.getDefaultLOD();
        }

        @Override
        public void create(Float argument, ResourceLocation modelLocation) {
            this.levelsOfDetail.add(new LevelOfDetail<Float>(modelLocation, Float.valueOf(argument.floatValue() * argument.floatValue())));
        }

        private Vector3f getPositionFromPose(PoseStack poseStack) {
            Matrix4f pose = poseStack.last().pose();
            return new Vector3f(pose.m30(), pose.m31(), pose.m32());
        }
    }

    private static class GraphicsSettingsLODStrategy
    extends LODStrategy<GraphicsStatus> {
        public GraphicsSettingsLODStrategy(Consumer<LODBuilder<GraphicsStatus>> lodBuilder) {
            super(lodBuilder);
        }

        @Override
        public LevelOfDetail<GraphicsStatus> getLODLevel(PoseStack poseStack) {
            GraphicsStatus graphicsQuality = (GraphicsStatus)Minecraft.getInstance().options.graphicsMode().get();
            for (LevelOfDetail levelOfDetail : this.levelsOfDetail) {
                if (graphicsQuality != levelOfDetail.getArgument()) continue;
                return levelOfDetail;
            }
            return this.getDefaultLOD();
        }

        @Override
        public void create(GraphicsStatus argument, ResourceLocation modelLocation) {
            if (this.checkForDuplicates(argument)) {
                throw new IllegalArgumentException("Duplicate graphics status found: " + String.valueOf(argument));
            }
            this.levelsOfDetail.add(new LevelOfDetail<GraphicsStatus>(modelLocation, argument));
        }

        private boolean checkForDuplicates(GraphicsStatus argument) {
            for (LevelOfDetail levelOfDetail : this.levelsOfDetail) {
                if (!((GraphicsStatus)levelOfDetail.getArgument()).equals((Object)argument)) continue;
                return true;
            }
            return false;
        }
    }
}

