/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.lodestar.lodestone.compability.CuriosCompat;
import team.lodestar.lodestone.config.ClientConfig;
import team.lodestar.lodestone.data.LodestoneBlockTagDatagen;
import team.lodestar.lodestone.data.LodestoneDamageTypeDatagen;
import team.lodestar.lodestone.data.LodestoneItemTagDatagen;
import team.lodestar.lodestone.data.LodestoneLangDatagen;
import team.lodestar.lodestone.registry.common.LodestoneAttachmentTypes;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.registry.common.LodestoneBlockEntities;
import team.lodestar.lodestone.registry.common.LodestoneCommandArgumentTypes;
import team.lodestar.lodestone.registry.common.LodestonePlacementFillers;
import team.lodestar.lodestone.registry.common.LodestoneRecipeSerializers;
import team.lodestar.lodestone.registry.common.LodestoneWorldEventTypes;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleTypes;

@Mod(value="lodestone")
public class LodestoneLib {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String LODESTONE = "lodestone";
    public static final RandomSource RANDOM = RandomSource.create();

    public LodestoneLib() {
        IEventBus modBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        LodestoneBlockEntities.BLOCK_ENTITY_TYPES.register(modBus);
        LodestoneParticleTypes.PARTICLES.register(modBus);
        LodestoneAttributes.ATTRIBUTES.register(modBus);
        LodestoneRecipeSerializers.RECIPE_SERIALIZERS.register(modBus);
        LodestoneAttachmentTypes.ATTACHMENT_TYPES.register(modBus);
        LodestonePlacementFillers.MODIFIERS.register(modBus);
        LodestoneWorldEventTypes.WORLD_EVENT_TYPES.register(modBus);
        LodestoneCommandArgumentTypes.register(modBus);
        CuriosCompat.init();
        modBus.addListener(this::gatherData);
    }

    public static ResourceLocation lodestonePath(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)LODESTONE, (String)path);
    }

    public void gatherData(GatherDataEvent event) {
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput packOutput = event.getGenerator().getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        LodestoneBlockTagDatagen blockTagDatagen = new LodestoneBlockTagDatagen(packOutput, lookupProvider, existingFileHelper);
        event.getGenerator().addProvider(true, (DataProvider)new LodestoneLangDatagen(packOutput));
        event.getGenerator().addProvider(true, (DataProvider)blockTagDatagen);
        event.getGenerator().addProvider(true, (DataProvider)new LodestoneItemTagDatagen(packOutput, lookupProvider, blockTagDatagen.contentsGetter(), existingFileHelper));
        event.getGenerator().addProvider(true, (DataProvider)new LodestoneDamageTypeDatagen(packOutput, lookupProvider, existingFileHelper));
    }
}

