/*
 * Decompiled with CFR 0.152.
 */
package net.akaneo.fastfooddelight.common.world;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.akaneo.fastfooddelight.common.Config.FFConfiguration;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

public class FFVillageStructures {
    public static void addNewVillageBuilding(ServerAboutToStartEvent event) {
        if (!FFConfiguration.getInstance().doGenerateStructures()) {
            return;
        }
        int WeightOfStructure = FFConfiguration.getInstance().SWeight();
        Registry templatePools = (Registry)event.getServer().registryAccess().registry(Registries.TEMPLATE_POOL).get();
        Registry processorLists = (Registry)event.getServer().registryAccess().registry(Registries.PROCESSOR_LIST).get();
        FFVillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/plains/houses"), "fastfooddelight:village/houses/plains_fast_food", WeightOfStructure);
        FFVillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/snowy/houses"), "fastfooddelight:village/houses/snowy_fast_food", WeightOfStructure);
        FFVillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/savanna/houses"), "fastfooddelight:village/houses/savanna_fast_food", WeightOfStructure);
        FFVillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/desert/houses"), "fastfooddelight:village/houses/desert_fast_food", WeightOfStructure);
        FFVillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/taiga/houses"), "fastfooddelight:village/houses/taiga_fast_food", WeightOfStructure);
    }

    public static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.get(poolRL);
        if (pool == null) {
            return;
        }
        ResourceLocation emptyProcessor = ResourceLocation.withDefaultNamespace((String)"empty");
        Holder.Reference processorHolder = processorListRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)emptyProcessor));
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.single((String)nbtPieceRL, (Holder)processorHolder).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.rawTemplates);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.rawTemplates = listOfPieceEntries;
    }
}

