/*
 * Decompiled with CFR 0.152.
 */
package net.akaneo.fastfooddelight.common.registry;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.akaneo.fastfooddelight.common.registry.FFBlocks;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class FFVillagers {
    public static final DeferredRegister<PoiType> POI = DeferredRegister.create((ResourceKey)Registries.POINT_OF_INTEREST_TYPE, (String)"fastfooddelight");
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((ResourceKey)Registries.VILLAGER_PROFESSION, (String)"fastfooddelight");
    public static final DeferredHolder<PoiType, PoiType> CHECKOUT_MACHINE_POI = POI.register("checkout_machine_poi", () -> new PoiType(FFVillagers.getAllStates((Block)FFBlocks.CHECKOUT_MACHINE.get()), 1, 1));
    public static final Supplier<VillagerProfession> FAST_FOOD_WAITER = FFVillagers.registerProfession("fast_food_waiter", CHECKOUT_MACHINE_POI, SoundEvents.VILLAGER_WORK_BUTCHER);

    public static ResourceLocation RL(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"fastfooddelight", (String)path);
    }

    private static Supplier<VillagerProfession> registerProfession(String name, DeferredHolder<PoiType, PoiType> poiType, SoundEvent sound) {
        return PROFESSIONS.register(name, () -> FFVillagers.register(FFVillagers.RL(name), poiType, sound));
    }

    private static VillagerProfession register(ResourceLocation name, DeferredHolder<PoiType, PoiType> poi, SoundEvent sound) {
        ResourceKey poiName = Objects.requireNonNull(poi.getKey());
        return new VillagerProfession(name.toString(), holder -> holder.is(poiName), holder -> holder.is(poiName), ImmutableSet.of(), ImmutableSet.of(), sound);
    }

    private static Set<BlockState> getAllStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.getStateDefinition().getPossibleStates());
    }
}

