/*
 * Decompiled with CFR 0.152.
 */
package toni.lib.utils;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ColorUtils {
    public static int alpha(int color) {
        return color >>> 24;
    }

    public static int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color & 0xFF;
    }

    public static int color(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int color(int red, int green, int blue) {
        return ColorUtils.color(255, red, green, blue);
    }

    public static int color(Vec3 color) {
        return ColorUtils.color(ColorUtils.as8BitChannel((float)color.x()), ColorUtils.as8BitChannel((float)color.y()), ColorUtils.as8BitChannel((float)color.z()));
    }

    public static int multiply(int color1, int color2) {
        if (color1 == -1) {
            return color2;
        }
        return color2 == -1 ? color1 : ColorUtils.color(ColorUtils.alpha(color1) * ColorUtils.alpha(color2) / 255, ColorUtils.red(color1) * ColorUtils.red(color2) / 255, ColorUtils.green(color1) * ColorUtils.green(color2) / 255, ColorUtils.blue(color1) * ColorUtils.blue(color2) / 255);
    }

    public static int scaleRGB(int color, float scale) {
        return ColorUtils.scaleRGB(color, scale, scale, scale);
    }

    public static int scaleRGB(int color, float redScale, float greenScale, float blueScale) {
        return ColorUtils.color(ColorUtils.alpha(color), Math.clamp((long)((int)((float)ColorUtils.red(color) * redScale)), 0, 255), Math.clamp((long)((int)((float)ColorUtils.green(color) * greenScale)), 0, 255), Math.clamp((long)((int)((float)ColorUtils.blue(color) * blueScale)), 0, 255));
    }

    public static int scaleRGB(int color, int scale) {
        return ColorUtils.color(ColorUtils.alpha(color), Math.clamp((long)ColorUtils.red(color) * (long)scale / 255L, 0, 255), Math.clamp((long)ColorUtils.green(color) * (long)scale / 255L, 0, 255), Math.clamp((long)ColorUtils.blue(color) * (long)scale / 255L, 0, 255));
    }

    public static int greyscale(int color) {
        int i = (int)((float)ColorUtils.red(color) * 0.3f + (float)ColorUtils.green(color) * 0.59f + (float)ColorUtils.blue(color) * 0.11f);
        return ColorUtils.color(i, i, i);
    }

    public static int lerp(float delta, int color1, int color2) {
        int i = Mth.lerpInt((float)delta, (int)ColorUtils.alpha(color1), (int)ColorUtils.alpha(color2));
        int j = Mth.lerpInt((float)delta, (int)ColorUtils.red(color1), (int)ColorUtils.red(color2));
        int k = Mth.lerpInt((float)delta, (int)ColorUtils.green(color1), (int)ColorUtils.green(color2));
        int l = Mth.lerpInt((float)delta, (int)ColorUtils.blue(color1), (int)ColorUtils.blue(color2));
        return ColorUtils.color(i, j, k, l);
    }

    public static int opaque(int color) {
        return color | 0xFF000000;
    }

    public static int transparent(int color) {
        return color & 0xFFFFFF;
    }

    public static int color(int alpha, int color) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    public static int white(float alpha) {
        return ColorUtils.as8BitChannel(alpha) << 24 | 0xFFFFFF;
    }

    public static int colorFromFloat(float alpha, float red, float green, float blue) {
        return ColorUtils.color(ColorUtils.as8BitChannel(alpha), ColorUtils.as8BitChannel(red), ColorUtils.as8BitChannel(green), ColorUtils.as8BitChannel(blue));
    }

    public static Vector3f vector3fFromRGB24(int color) {
        float f = (float)ColorUtils.red(color) / 255.0f;
        float g = (float)ColorUtils.green(color) / 255.0f;
        float h = (float)ColorUtils.blue(color) / 255.0f;
        return new Vector3f(f, g, h);
    }

    public static int average(int color1, int color2) {
        return ColorUtils.color((ColorUtils.alpha(color1) + ColorUtils.alpha(color2)) / 2, (ColorUtils.red(color1) + ColorUtils.red(color2)) / 2, (ColorUtils.green(color1) + ColorUtils.green(color2)) / 2, (ColorUtils.blue(color1) + ColorUtils.blue(color2)) / 2);
    }

    public static int as8BitChannel(float value) {
        return Mth.floor((float)(value * 255.0f));
    }

    public static float alphaFloat(int color) {
        return ColorUtils.from8BitChannel(ColorUtils.alpha(color));
    }

    public static float redFloat(int color) {
        return ColorUtils.from8BitChannel(ColorUtils.red(color));
    }

    public static float greenFloat(int color) {
        return ColorUtils.from8BitChannel(ColorUtils.green(color));
    }

    public static float blueFloat(int color) {
        return ColorUtils.from8BitChannel(ColorUtils.blue(color));
    }

    private static float from8BitChannel(int value) {
        return (float)value / 255.0f;
    }

    public static int toABGR(int color) {
        return color & 0xFF00FF00 | (color & 0xFF0000) >> 16 | (color & 0xFF) << 16;
    }

    public static int fromABGR(int color) {
        return ColorUtils.toABGR(color);
    }
}

