/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.datagen;

import com.lumengrid.oritechthings.datagen.ModBlockLootTableProvider;
import com.lumengrid.oritechthings.datagen.ModBlockStateProvider;
import com.lumengrid.oritechthings.datagen.ModBlockTagProvider;
import com.lumengrid.oritechthings.datagen.ModDatapackProvider;
import com.lumengrid.oritechthings.datagen.ModEntityLootTableProvider;
import com.lumengrid.oritechthings.datagen.ModItemModelProvider;
import com.lumengrid.oritechthings.datagen.ModItemTagProvider;
import com.lumengrid.oritechthings.datagen.ModLangProvider;
import com.lumengrid.oritechthings.datagen.ModLangProviderPtBr;
import com.lumengrid.oritechthings.datagen.ModLangProviderRuRu;
import com.lumengrid.oritechthings.datagen.ModLangProviderZhCn;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="oritechthings")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ModBlockTagProvider blockTagsProvider = new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)new ModDatapackProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(ModEntityLootTableProvider::new, LootContextParamSets.ENTITY)), lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLangProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLangProviderZhCn(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLangProviderRuRu(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLangProviderPtBr(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
    }
}

