/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.melscosmetics.procedures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ConveyorBeltPushProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (!entity.getType().is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)"minecraft:deco_conveyorbelt_cantpush")))) {
            if (ConveyorBeltPushProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) == Direction.NORTH) {
                entity.setDeltaMovement(new Vec3(0.0, 0.0, -0.1));
            } else if (ConveyorBeltPushProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) == Direction.SOUTH) {
                entity.setDeltaMovement(new Vec3(0.0, 0.0, 0.1));
            } else if (ConveyorBeltPushProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) == Direction.WEST) {
                entity.setDeltaMovement(new Vec3(-0.1, 0.0, 0.0));
            } else if (ConveyorBeltPushProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) == Direction.EAST) {
                entity.setDeltaMovement(new Vec3(0.1, 0.0, 0.0));
            }
        }
    }

    private static Direction getBlockDirection(LevelAccessor world, BlockPos pos) {
        Comparable comparable;
        BlockState blockState = world.getBlockState(pos);
        Property property = blockState.getBlock().getStateDefinition().getProperty("facing");
        if (property != null && (comparable = blockState.getValue(property)) instanceof Direction) {
            Direction direction = (Direction)comparable;
            return direction;
        }
        if (blockState.hasProperty((Property)BlockStateProperties.AXIS)) {
            return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)BlockStateProperties.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        }
        if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        }
        return Direction.NORTH;
    }
}

