/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.network;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.data.GradientData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.item.MechTrowelItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record GradientUpdatePacket(int trowelSlot, GradientData gradientData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GradientUpdatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mechtrowel", (String)"gradient_update"));
    public static final StreamCodec<FriendlyByteBuf, GradientUpdatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, GradientUpdatePacket::trowelSlot, GradientData.STREAM_CODEC, GradientUpdatePacket::gradientData, GradientUpdatePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player;
            ItemStack stack;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof Player && (stack = (player = patt0$temp).getInventory().getItem(this.trowelSlot)).getItem() instanceof MechTrowelItem) {
                TrowelData trowelData = TrowelData.getOrCreate(stack);
                GradientData currentGradientData = trowelData.getGradientData();
                currentGradientData.setSections(this.gradientData.getSections());
                currentGradientData.setAxis(this.gradientData.getAxis());
                currentGradientData.setPositionMode(this.gradientData.getPositionMode());
                currentGradientData.setStartPos(this.gradientData.getStartPos());
                currentGradientData.setEndPos(this.gradientData.getEndPos());
                currentGradientData.setRelativeDistance(this.gradientData.getRelativeDistance());
                currentGradientData.normalizeSections();
                trowelData.save(stack);
                MechTrowel.LOGGER.debug("Server: Updated gradient data - Mode={}, Start={}, End={}, RelDist={}, Sections={}", new Object[]{currentGradientData.getPositionMode(), currentGradientData.getStartPos(), currentGradientData.getEndPos(), currentGradientData.getRelativeDistance(), currentGradientData.getSections().size()});
            }
        });
    }
}

