/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.compat.jei;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.compat.jei.JeiCompat;
import com.asger.mechtrowel.compat.jei.JeiGhostIngredientHandlerAdapter;
import com.asger.mechtrowel.gui.PaletteScreen;
import com.asger.mechtrowel.registry.ModRegistry;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"mechtrowel", (String)"jei_plugin");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (!JeiCompat.isJeiLoaded()) {
            return;
        }
        try {
            JeiGhostIngredientHandlerAdapter adapter = new JeiGhostIngredientHandlerAdapter();
            registration.addGhostIngredientHandler(PaletteScreen.class, (IGhostIngredientHandler)adapter);
            MechTrowel.LOGGER.info("Successfully registered JEI ghost ingredient handler for PaletteScreen");
        }
        catch (Exception e) {
            MechTrowel.LOGGER.error("Error registering JEI handlers: " + e.getMessage(), (Throwable)e);
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        if (!JeiCompat.isJeiLoaded()) {
            return;
        }
        try {
            IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
            if (!MechTrowel.Config.isWandUpgradeEnabled()) {
                ingredientManager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, List.of(new ItemStack((ItemLike)ModRegistry.WAND_TEMPLATE.get())));
                MechTrowel.LOGGER.info("Hid wand template item from JEI (wandUpgradeEnabled=false)");
            }
            if (!MechTrowel.Config.isWandCapacityUpgradeEnabled()) {
                ingredientManager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, List.of(new ItemStack((ItemLike)ModRegistry.WAND_CAPACITY_TEMPLATE.get())));
                MechTrowel.LOGGER.info("Hid wand capacity template item from JEI (wandCapacityUpgradeEnabled=false)");
            }
        }
        catch (Exception e) {
            MechTrowel.LOGGER.error("Error hiding items in JEI: " + e.getMessage(), (Throwable)e);
        }
    }
}

