/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.compat.framedblocks;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.compat.create.CreateCompat;
import com.asger.mechtrowel.compat.framedblocks.FramedIntegration;
import com.asger.mechtrowel.util.InventorySearchHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModList;

public class FramedBlocksCompat {
    private static boolean framedBlocksLoaded = false;

    public static boolean isFramedBlocksLoaded() {
        return framedBlocksLoaded;
    }

    public static boolean isFramedBlock(Block block) {
        if (!framedBlocksLoaded) {
            return false;
        }
        try {
            String blockId = block.getDescriptionId();
            return blockId.contains("framedblocks") && blockId.contains("framed");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidFramedCamo(Block block) {
        if (!framedBlocksLoaded) {
            return false;
        }
        if (FramedBlocksCompat.isFramedBlock(block)) {
            MechTrowel.LOGGER.debug("Blocked framed block as camo: {}", (Object)block.getDescriptionId());
            return false;
        }
        if (CreateCompat.isCopycatBlock(block)) {
            MechTrowel.LOGGER.debug("Blocked copycat block as framed camo: {}", (Object)block.getDescriptionId());
            return false;
        }
        try {
            BlockState state = block.defaultBlockState();
            if (state.hasBlockEntity()) {
                MechTrowel.LOGGER.debug("Blocked BlockEntity block as camo: {}", (Object)block.getDescriptionId());
                return false;
            }
        }
        catch (Exception e) {
            MechTrowel.LOGGER.warn("Error checking BlockEntity for camo: {}", (Object)block.getDescriptionId(), (Object)e);
            return false;
        }
        return true;
    }

    public static boolean applyCamo(Level level, BlockPos pos, BlockState camo, Player player) {
        if (!framedBlocksLoaded) {
            MechTrowel.LOGGER.debug("FramedBlocks not loaded, skipping camo application");
            return false;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            MechTrowel.LOGGER.debug("No block entity at {}, cannot apply camo", (Object)pos);
            return false;
        }
        String className = blockEntity.getClass().getName();
        if (!className.contains("framed") && !className.contains("Framed")) {
            MechTrowel.LOGGER.debug("Block entity {} is not a framed block entity", (Object)className);
            return false;
        }
        try {
            MechTrowel.LOGGER.debug("Attempting to apply camo {} to framed block at {}", (Object)camo.getBlock().getDescriptionId(), (Object)pos);
            boolean success = FramedIntegration.applyCamo(blockEntity, camo, player);
            if (success) {
                MechTrowel.LOGGER.debug("Successfully applied camo to framed block at {}", (Object)pos);
            } else {
                MechTrowel.LOGGER.debug("Failed to apply camo to framed block at {}", (Object)pos);
            }
            return success;
        }
        catch (Exception e) {
            MechTrowel.LOGGER.error("Error applying camo to framed block at {}", (Object)pos, (Object)e);
            return false;
        }
    }

    public static boolean consumeCamo(Player player, ItemStack camo) {
        if (player.isCreative()) {
            return true;
        }
        Item item = camo.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            boolean consumed = InventorySearchHelper.consumeBlock(player, blockItem.getBlock(), false);
            if (consumed) {
                MechTrowel.LOGGER.debug("Consumed camo material: {}", (Object)camo.getItem().getDescriptionId());
            } else {
                MechTrowel.LOGGER.debug("No camo material found in inventory: {}", (Object)camo.getItem().getDescriptionId());
            }
            return consumed;
        }
        MechTrowel.LOGGER.debug("Camo is not a block item: {}", (Object)camo.getItem().getDescriptionId());
        return false;
    }

    static {
        try {
            framedBlocksLoaded = ModList.get().isLoaded("framedblocks");
            if (framedBlocksLoaded) {
                MechTrowel.LOGGER.info("FramedBlocks mod detected - enabling compatibility");
            }
        }
        catch (Exception e) {
            MechTrowel.LOGGER.error("Error checking for FramedBlocks mod", (Throwable)e);
            framedBlocksLoaded = false;
        }
    }
}

