/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.client.render;

import com.asger.mechtrowel.MechTrowel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class TrowelItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static TrowelItemRenderer instance;
    private static long lastPlacementTime;
    private static final float PLACEMENT_ANIM_DURATION = 300.0f;
    public static final ModelResourceLocation TROWEL_BLADE_MODEL;
    public static final ModelResourceLocation TROWEL_HANDLE_MODEL;
    public static final ModelResourceLocation TROWEL_COG_MODEL;
    public static final ModelResourceLocation TROWEL_2D_MODEL;

    public TrowelItemRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
    }

    public static TrowelItemRenderer getInstance() {
        if (instance == null) {
            Minecraft mc = Minecraft.getInstance();
            instance = new TrowelItemRenderer(mc.getBlockEntityRenderDispatcher(), mc.getEntityModels());
        }
        return instance;
    }

    public static void triggerPlacementAnimation() {
        lastPlacementTime = System.currentTimeMillis();
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (!MechTrowel.ClientConfig.isEnable3DModel()) {
            this.renderNormalModel(poseStack, buffer, packedLight, packedOverlay);
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        this.render3DModel(stack, displayContext, poseStack, buffer, packedLight, packedOverlay, mc.getItemRenderer());
    }

    private void renderNormalModel(PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Minecraft mc = Minecraft.getInstance();
        BakedModel model = mc.getModelManager().getModel(TROWEL_2D_MODEL);
        if (model == null || model == mc.getModelManager().getMissingModel()) {
            return;
        }
        RandomSource random = mc.level != null ? mc.level.random : RandomSource.create();
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.cutout());
        for (BakedQuad quad : model.getQuads(null, null, random)) {
            vertexConsumer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
        }
        for (Direction dir : Direction.values()) {
            for (BakedQuad quad : model.getQuads(null, dir, random)) {
                vertexConsumer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
            }
        }
    }

    private void render3DModel(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, ItemRenderer itemRenderer) {
        float finalTilt;
        float scale;
        float rotateX;
        float rotateY;
        float rotateZ;
        float translateZ;
        float translateY;
        float translateX;
        boolean isFixed;
        poseStack.pushPose();
        boolean disableAnimation = false;
        boolean isThirdPerson = displayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        boolean isGui = displayContext == ItemDisplayContext.GUI;
        boolean isGround = displayContext == ItemDisplayContext.GROUND;
        boolean bl = isFixed = displayContext == ItemDisplayContext.FIXED;
        if (isGui) {
            translateX = 0.6f;
            translateY = 0.55f;
            translateZ = 0.0f;
            rotateZ = -195.0f;
            rotateY = -145.0f;
            rotateX = -25.0f;
            scale = 0.86f;
            disableAnimation = true;
        } else if (isGround) {
            translateX = 0.5f;
            translateY = 0.5f;
            translateZ = 0.5f;
            rotateX = 0.0f;
            rotateY = 0.0f;
            rotateZ = 0.0f;
            scale = 0.5f;
            disableAnimation = true;
        } else if (isFixed) {
            translateX = 0.5f;
            translateY = 0.4f;
            translateZ = 0.5f;
            rotateX = 0.0f;
            rotateY = 180.0f;
            rotateZ = 0.0f;
            scale = 1.0f;
            disableAnimation = true;
        } else if (isThirdPerson) {
            translateX = 0.5f;
            translateY = 0.45f;
            translateZ = 0.05f;
            rotateX = -57.0f;
            rotateY = -90.0f;
            rotateZ = 0.0f;
            scale = 0.6f;
        } else {
            translateX = -0.15f;
            translateY = 0.18f;
            translateZ = 0.5f;
            rotateX = 18.0f;
            rotateY = -90.0f;
            rotateZ = 0.0f;
            scale = 1.0f;
        }
        float idleStartDegree = 0.0f;
        float idleEndDegree = 20.0f;
        float idleSpeed = 1.0f;
        float speedVariationAmount = 0.1f;
        float pivotX = 0.0f;
        float pivotY = 0.17f;
        float pivotZ = 0.0f;
        float placementStartDegree = 0.0f;
        float placementPeakDegree = 30.0f;
        float placementEndDegree = -10.0f;
        float blendDuration = 200.0f;
        long currentTime = System.currentTimeMillis();
        float timeSincePlacement = currentTime - lastPlacementTime;
        float placementProgress = timeSincePlacement / 300.0f;
        boolean isPlacementAnimating = placementProgress < 1.0f && placementProgress >= 0.0f;
        boolean isBlending = !isPlacementAnimating && timeSincePlacement < 300.0f + blendDuration;
        float time = (float)(currentTime % 100000L) / 1000.0f;
        float mainWave = (float)Math.sin(time * idleSpeed);
        float variationWave = (float)Math.sin(time * 0.23f) * speedVariationAmount;
        float idleT = (mainWave * (1.0f + variationWave) + 1.0f) / 2.0f;
        idleT = Math.max(0.0f, Math.min(1.0f, idleT));
        float idleTilt = idleStartDegree + (idleEndDegree - idleStartDegree) * idleT;
        if (disableAnimation) {
            finalTilt = 0.0f;
        } else if (isPlacementAnimating) {
            if (placementProgress < 0.3f) {
                float p = placementProgress / 0.3f;
                p = 1.0f - (1.0f - p) * (1.0f - p);
                finalTilt = placementStartDegree + (placementPeakDegree - placementStartDegree) * p;
            } else {
                float p = (placementProgress - 0.3f) / 0.7f;
                p = 1.0f - (1.0f - p) * (1.0f - p);
                finalTilt = placementPeakDegree + (placementEndDegree - placementPeakDegree) * p;
            }
        } else if (isBlending) {
            float blendProgress = (timeSincePlacement - 300.0f) / blendDuration;
            blendProgress = blendProgress * blendProgress * (3.0f - 2.0f * blendProgress);
            finalTilt = placementEndDegree + (idleTilt - placementEndDegree) * blendProgress;
        } else {
            finalTilt = idleTilt;
        }
        if (isGui) {
            poseStack.translate(translateX, translateY, translateZ);
            if (rotateZ != 0.0f) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(rotateZ));
            }
            if (rotateY != 0.0f) {
                poseStack.mulPose(Axis.YP.rotationDegrees(rotateY));
            }
            if (rotateX != 0.0f) {
                poseStack.mulPose(Axis.XP.rotationDegrees(rotateX));
            }
        } else if (isGround || isFixed) {
            poseStack.translate(translateX, translateY, translateZ);
            if (rotateY != 0.0f) {
                poseStack.mulPose(Axis.YP.rotationDegrees(rotateY));
            }
            if (rotateX != 0.0f) {
                poseStack.mulPose(Axis.XP.rotationDegrees(rotateX));
            }
            if (rotateZ != 0.0f) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(rotateZ));
            }
        } else if (isThirdPerson) {
            if (rotateY != 0.0f) {
                poseStack.mulPose(Axis.YP.rotationDegrees(rotateY));
            }
            if (rotateX != 0.0f) {
                poseStack.mulPose(Axis.XP.rotationDegrees(rotateX));
            }
            if (rotateZ != 0.0f) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(rotateZ));
            }
            poseStack.translate(translateX, translateY, translateZ);
        } else {
            poseStack.translate(translateX, translateY, translateZ);
            if (rotateY != 0.0f) {
                poseStack.mulPose(Axis.YP.rotationDegrees(rotateY));
            }
            if (rotateX != 0.0f) {
                poseStack.mulPose(Axis.XP.rotationDegrees(rotateX));
            }
            if (rotateZ != 0.0f) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(rotateZ));
            }
        }
        if (scale != 1.0f) {
            poseStack.scale(scale, scale, scale);
        }
        this.renderModelPart(stack, poseStack, buffer, packedLight, packedOverlay, TROWEL_HANDLE_MODEL, itemRenderer);
        poseStack.pushPose();
        poseStack.translate(pivotX, pivotY, pivotZ);
        poseStack.mulPose(Axis.XP.rotationDegrees(finalTilt));
        poseStack.translate(-pivotX, -pivotY, -pivotZ);
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.01f, 0.0f);
        this.renderModelPart(stack, poseStack, buffer, packedLight, packedOverlay, TROWEL_COG_MODEL, itemRenderer);
        poseStack.popPose();
        this.renderModelPart(stack, poseStack, buffer, packedLight, packedOverlay, TROWEL_BLADE_MODEL, itemRenderer);
        poseStack.popPose();
        poseStack.popPose();
    }

    private void renderModelPart(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, ModelResourceLocation modelLocation, ItemRenderer itemRenderer) {
        Minecraft mc = Minecraft.getInstance();
        BakedModel model = mc.getModelManager().getModel(modelLocation);
        if (model != null && model != mc.getModelManager().getMissingModel()) {
            itemRenderer.render(stack, ItemDisplayContext.NONE, false, poseStack, buffer, packedLight, packedOverlay, model);
        }
    }

    static {
        lastPlacementTime = 0L;
        TROWEL_BLADE_MODEL = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mechtrowel", (String)"item/mech_trowel_blade"));
        TROWEL_HANDLE_MODEL = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mechtrowel", (String)"item/mech_trowel_handle"));
        TROWEL_COG_MODEL = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mechtrowel", (String)"item/mech_trowel_cog"));
        TROWEL_2D_MODEL = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mechtrowel", (String)"item/mech_trowel_2d"));
    }
}

