/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel;

import com.asger.mechtrowel.client.KeyBindings;
import com.asger.mechtrowel.client.render.TrowelItemRenderer;
import com.asger.mechtrowel.client.screen.GradientScreen;
import com.asger.mechtrowel.compat.jei.JeiCompat;
import com.asger.mechtrowel.events.TooltipEventHandler;
import com.asger.mechtrowel.gui.PaletteScreen;
import com.asger.mechtrowel.network.ModNetwork;
import com.asger.mechtrowel.registry.ModConditions;
import com.asger.mechtrowel.registry.ModRegistry;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;

@Mod(value="mechtrowel")
public class MechTrowel {
    public static final String MOD_ID = "mechtrowel";
    public static final Logger LOGGER = LogUtils.getLogger();

    public MechTrowel(IEventBus modEventBus, ModContainer modContainer) {
        LOGGER.info("Initializing MechTrowel mod");
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        ModRegistry.init(modEventBus);
        ModConditions.register(modEventBus);
        ModNetwork.init();
        modEventBus.addListener(ModNetwork::registerPayloads);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(this::onRegisterKeyMappings);
            modEventBus.addListener(this::onClientSetup);
            modEventBus.addListener(this::onRegisterMenuScreens);
            modEventBus.addListener(this::onRegisterAdditionalModels);
        }
        JeiCompat.init();
    }

    private void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        LOGGER.debug("Registering key mappings");
        KeyBindings.register(event);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Initializing MechTrowel client");
        NeoForge.EVENT_BUS.register(TooltipEventHandler.class);
    }

    private void onRegisterMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModRegistry.PALETTE_MENU.get(), PaletteScreen::new);
        event.register((MenuType)ModRegistry.GRADIENT_MENU_TYPE.get(), GradientScreen::new);
    }

    private void onRegisterAdditionalModels(ModelEvent.RegisterAdditional event) {
        event.register(TrowelItemRenderer.TROWEL_2D_MODEL);
        event.register(TrowelItemRenderer.TROWEL_HANDLE_MODEL);
        event.register(TrowelItemRenderer.TROWEL_BLADE_MODEL);
        event.register(TrowelItemRenderer.TROWEL_COG_MODEL);
        LOGGER.debug("Registered additional model parts for Mech Trowel");
    }

    public static class Config {
        private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
        private static final ModConfigSpec.IntValue TROWEL_DURABILITY = BUILDER.comment("Durability of the Mech Trowel (0 = infinite/no durability)").defineInRange("trowelDurability", 0, 0, 10000);
        private static final ModConfigSpec.IntValue SINGLE_PLACE_DURABILITY_COST = BUILDER.comment("Durability cost per single block placement").defineInRange("singlePlaceDurabilityCost", 1, 1, 100);
        private static final ModConfigSpec.IntValue WAND_PLACE_DURABILITY_COST = BUILDER.comment("Durability cost per wand mode action").defineInRange("wandPlaceDurabilityCost", 8, 1, 100);
        private static final ModConfigSpec.BooleanValue REPLACE_MODE_ENABLED = BUILDER.comment("Enable replace mode functionality").define("replaceModeEnabled", true);
        private static final ModConfigSpec.IntValue MAX_PALETTES = BUILDER.comment("Maximum number of palettes that can be stored (will be rounded to nearest multiple of 7)").defineInRange("maxPalettes", 28, 7, 70);
        private static final ModConfigSpec.IntValue WAND_MAX_BLOCKS = BUILDER.comment("Maximum number of blocks that can be placed in one wand mode action as default").defineInRange("wandMaxBlocks", 64, 1, 256);
        private static final ModConfigSpec.IntValue WAND_MAX_RANGE = BUILDER.comment("Maximum range from clicked block for wand mode").defineInRange("wandMaxRange", 64, 2, 256);
        private static final ModConfigSpec.BooleanValue WAND_UPGRADE_ENABLED = BUILDER.comment("Enable wand upgrade functionality").define("wandUpgradeEnabled", true);
        private static final ModConfigSpec.BooleanValue WAND_CAPACITY_UPGRADE_ENABLED = BUILDER.comment("Enable wand capacity upgrade functionality").define("wandCapacityUpgradeEnabled", true);
        private static final ModConfigSpec.BooleanValue WAND_MODE_WITHOUT_UPGRADE = BUILDER.comment("Allow wand mode without requiring upgrade item (default: false)").define("wandModeWithoutUpgrade", false);
        private static final ModConfigSpec.ConfigValue<List<? extends String>> REPLACE_BLACKLIST_BLOCKS = BUILDER.comment("List of blocks that cannot be replaced (e.g., 'minecraft:bedrock')").defineList("replaceBlacklistBlocks", List.of("minecraft:bedrock", "minecraft:end_portal", "minecraft:command_block", "minecraft:barrier"), obj -> obj instanceof String);
        private static final ModConfigSpec.ConfigValue<List<? extends String>> REPLACE_BLACKLIST_TAGS = BUILDER.comment("List of block tags that cannot be replaced (e.g., '#minecraft:wither_immune')").defineList("replaceBlacklistTags", List.of("#minecraft:wither_immune"), obj -> obj instanceof String && ((String)obj).startsWith("#"));
        private static final ModConfigSpec.BooleanValue CHIPPED_CONVERSION_UPGRADE_ENABLED = BUILDER.comment("Enable variant block auto-conversion upgrade functionality (Chipped, Rechiseled, etc.)").define("chippedConversionUpgradeEnabled", true);
        private static final ModConfigSpec.BooleanValue REACH_UPGRADE_ENABLED = BUILDER.comment("Enable reach upgrade functionality").define("reachUpgradeEnabled", true);
        private static final ModConfigSpec.DoubleValue REACH_UPGRADE_BONUS = BUILDER.comment("Additional block reach distance granted by reach upgrade").defineInRange("reachUpgradeBonus", 4.0, 0.0, 16.0);
        static final ModConfigSpec SPEC = BUILDER.build();

        public static int getTrowelDurability() {
            return (Integer)TROWEL_DURABILITY.get();
        }

        public static int getSinglePlaceDurabilityCost() {
            return (Integer)SINGLE_PLACE_DURABILITY_COST.get();
        }

        public static int getWandPlaceDurabilityCost() {
            return (Integer)WAND_PLACE_DURABILITY_COST.get();
        }

        public static int getMaxPalettes() {
            int configValue = (Integer)MAX_PALETTES.get();
            int rounded = Math.round((float)configValue / 7.0f) * 7;
            return Math.max(7, Math.min(70, rounded));
        }

        public static boolean isReplaceModeEnabled() {
            return (Boolean)REPLACE_MODE_ENABLED.get();
        }

        public static List<? extends String> getReplaceBlacklistBlocks() {
            return (List)REPLACE_BLACKLIST_BLOCKS.get();
        }

        public static List<? extends String> getReplaceBlacklistTags() {
            return (List)REPLACE_BLACKLIST_TAGS.get();
        }

        public static int getWandMaxBlocks() {
            return (Integer)WAND_MAX_BLOCKS.get();
        }

        public static int getWandMaxRange() {
            return (Integer)WAND_MAX_RANGE.get();
        }

        public static boolean isWandUpgradeEnabled() {
            return (Boolean)WAND_UPGRADE_ENABLED.get();
        }

        public static boolean isWandCapacityUpgradeEnabled() {
            return (Boolean)WAND_CAPACITY_UPGRADE_ENABLED.get();
        }

        public static boolean isWandModeWithoutUpgrade() {
            return (Boolean)WAND_MODE_WITHOUT_UPGRADE.get();
        }

        public static boolean isChippedConversionUpgradeEnabled() {
            return (Boolean)CHIPPED_CONVERSION_UPGRADE_ENABLED.get();
        }

        public static boolean isReachUpgradeEnabled() {
            return (Boolean)REACH_UPGRADE_ENABLED.get();
        }

        public static double getReachUpgradeBonus() {
            return (Double)REACH_UPGRADE_BONUS.get();
        }
    }

    public static class ClientConfig {
        private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
        private static final boolean DEFAULT_3D_MODEL = ModList.get().isLoaded("create");
        private static final ModConfigSpec.BooleanValue ENABLE_3D_MODEL = BUILDER.comment(new String[]{"Enable 3D animated model for the Mech Trowel.", "Defaults to true when Create mod is installed, false otherwise."}).define("enable3DModel", DEFAULT_3D_MODEL);
        static final ModConfigSpec SPEC = BUILDER.build();

        public static boolean isEnable3DModel() {
            return (Boolean)ENABLE_3D_MODEL.get();
        }
    }
}

