/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.common.blockentity;

import dev.xylonity.knightlib.api.impl.GreatChaliceState;
import dev.xylonity.knightlib.registry.KnightLibBlockEntities;
import dev.xylonity.knightlib.registry.KnightLibParticles;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GreatChaliceBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int charges = 0;
    private int prevCharges = 0;
    private GreatChaliceState state = GreatChaliceState.EMPTY;
    private long tickcount = 0L;

    public GreatChaliceBlockEntity(BlockPos pos, BlockState state) {
        super(KnightLibBlockEntities.GREAT_CHALICE.get(), pos, state);
    }

    public int getCharges() {
        return this.charges;
    }

    public void setCharges(int charges) {
        this.charges = Math.min(charges, 12);
        if (charges == 0) {
            this.setState(GreatChaliceState.EMPTY);
        }
        this.prevCharges = this.charges;
        this.setChanged();
        this.sync();
    }

    public GreatChaliceState getState() {
        return this.state;
    }

    public boolean isFull() {
        return this.getCharges() == 12;
    }

    public void setState(GreatChaliceState newState) {
        if (this.state == newState) {
            return;
        }
        this.state = newState;
        this.setChanged();
        this.sync();
    }

    protected void saveAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("Charges", this.charges);
        pTag.putInt("PrevCharges", this.prevCharges);
        pTag.putString("State", this.state.getSerializedName());
    }

    protected void loadAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.charges = pTag.getInt("Charges");
        this.prevCharges = pTag.getInt("PrevCharges");
        try {
            this.state = GreatChaliceState.valueOf(pTag.getString("State").toUpperCase());
        }
        catch (Exception e) {
            this.state = GreatChaliceState.NORMAL;
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        CompoundTag tag = super.getUpdateTag(pRegistries);
        tag.putInt("Charges", this.charges);
        tag.putInt("PrevCharges", this.prevCharges);
        tag.putString("State", this.state.getSerializedName());
        return tag;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T F) {
        if (!(F instanceof GreatChaliceBlockEntity)) {
            return;
        }
        GreatChaliceBlockEntity chalice = (GreatChaliceBlockEntity)F;
        if (chalice.charges == 12 && chalice.tickcount % 15L == 0L) {
            chalice.spawnSpecialParticles();
        }
        if (chalice.charges == 12 && chalice.tickcount % 5L == 0L) {
            chalice.spawnChaoticParticles();
        }
        if (chalice.tickcount % 5L == 0L) {
            chalice.spawnProgressiveParticles(pos);
        }
        ++chalice.tickcount;
    }

    private void spawnSpecialParticles() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            if (this.getState() == GreatChaliceState.NORMAL) {
                for (int i = 0; i < 2; ++i) {
                    double dx = (new Random().nextDouble() - 0.5) * 0.5;
                    double dy = (new Random().nextDouble() - 0.5) * 0.5;
                    double dz = (new Random().nextDouble() - 0.5) * 0.5;
                    if (i % 3 != 0) continue;
                    sv.sendParticles((ParticleOptions)KnightLibParticles.STARSET.get(), (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5 * Math.random(), (double)this.getBlockPos().getZ() + 0.5, 1, dx, dy, dz, 0.35);
                }
            }
        }
    }

    private void spawnChaoticParticles() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            if (this.getState() == GreatChaliceState.CHAOTIC) {
                double dz;
                double dy;
                double dx;
                int i;
                for (i = 0; i < 2; ++i) {
                    dx = (new Random().nextDouble() - 0.5) * 0.5;
                    dy = (new Random().nextDouble() - 0.5) * 0.5;
                    dz = (new Random().nextDouble() - 0.5) * 0.5;
                    sv.sendParticles((ParticleOptions)ParticleTypes.WARPED_SPORE, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5 * Math.random(), (double)this.getBlockPos().getZ() + 0.5, 1, dx, dy, dz, 0.3);
                }
                for (i = 0; i < 2; ++i) {
                    dx = (new Random().nextDouble() - 0.5) * 0.5;
                    dy = (new Random().nextDouble() - 0.5) * 0.5;
                    dz = (new Random().nextDouble() - 0.5) * 0.5;
                    sv.sendParticles((ParticleOptions)ParticleTypes.CRIMSON_SPORE, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5 * Math.random(), (double)this.getBlockPos().getZ() + 0.5, 1, dx, dy, dz, 0.25);
                }
            }
        }
    }

    private void spawnProgressiveParticles(BlockPos pos) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            for (int i = 0; i < this.charges; ++i) {
                if (!(sv.random.nextFloat() < 0.1f)) continue;
                sv.sendParticles((ParticleOptions)ParticleTypes.EFFECT, (double)pos.getX() + 0.5 + (sv.random.nextDouble() - 0.5) * 0.9, (double)pos.getY() + (double)this.getCharges() / 12.0 + sv.random.nextDouble() * 0.5, (double)pos.getZ() + 0.5 + (sv.random.nextDouble() - 0.5) * 0.9, 1, 0.0, 0.1, 0.0, 0.0);
            }
        }
    }

    public void sync() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ClientboundBlockEntityDataPacket pkt = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(this.worldPosition), false).forEach(arg_0 -> GreatChaliceBlockEntity.lambda$sync$0((Packet)pkt, arg_0));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static /* synthetic */ void lambda$sync$0(Packet pkt, ServerPlayer p) {
        p.connection.send(pkt);
    }
}

