/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.common.block;

import dev.xylonity.knightlib.common.block.ITickBlockTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTickBlock
extends Block
implements ITickBlockTracker {
    public AbstractTickBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void tick(@NotNull BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos blockPos, @NotNull RandomSource randomSource) {
        this.scheduleTick((Level)level, blockPos);
    }

    public void onPlace(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState newState, boolean b) {
        if (!level.isClientSide) {
            this.addTickBlock(blockPos, this);
            this.scheduleTick(level, blockPos);
        }
    }

    public void onRemove(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull BlockState newState, boolean movedByPiston) {
        if (!level.isClientSide) {
            this.removeTickBlock(blockPos);
        }
        super.onRemove(blockState, level, blockPos, newState, movedByPiston);
    }

    public void scheduleTick(Level pLevel, BlockPos pPos) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            serverLevel.scheduleTick(pPos, (Block)this, 1);
        }
    }
}

