/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.IdFunctionObject;
import dev.latvian.mods.rhino.IdScriptableObject;
import dev.latvian.mods.rhino.NativeSet;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Symbol;
import dev.latvian.mods.rhino.SymbolKey;
import dev.latvian.mods.rhino.Undefined;
import java.util.WeakHashMap;

public class NativeWeakSet
extends IdScriptableObject {
    private static final Object MAP_TAG = "WeakSet";
    private static final int Id_constructor = 1;
    private static final int Id_add = 2;
    private static final int Id_delete = 3;
    private static final int Id_has = 4;
    private static final int SymbolId_toStringTag = 5;
    private static final int MAX_PROTOTYPE_ID = 5;
    private final transient WeakHashMap<Scriptable, Boolean> map = new WeakHashMap();
    private boolean instanceOfWeakSet = false;

    static void init(Scriptable scope, boolean sealed, Context cx) {
        NativeWeakSet m = new NativeWeakSet();
        m.exportAsJSClass(5, scope, sealed, cx);
    }

    private static NativeWeakSet realThis(Scriptable thisObj, IdFunctionObject f, Context cx) {
        if (thisObj == null) {
            throw NativeWeakSet.incompatibleCallError(f, cx);
        }
        try {
            NativeWeakSet ns = (NativeWeakSet)thisObj;
            if (!ns.instanceOfWeakSet) {
                throw NativeWeakSet.incompatibleCallError(f, cx);
            }
            return ns;
        }
        catch (ClassCastException cce) {
            throw NativeWeakSet.incompatibleCallError(f, cx);
        }
    }

    @Override
    public String getClassName() {
        return "WeakSet";
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(MAP_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                if (thisObj == null) {
                    NativeWeakSet ns = new NativeWeakSet();
                    ns.instanceOfWeakSet = true;
                    if (args.length > 0) {
                        NativeSet.loadFromIterable(cx, scope, ns, args[0]);
                    }
                    return ns;
                }
                throw ScriptRuntime.typeError1(cx, "msg.no.new", "WeakSet");
            }
            case 2: {
                return NativeWeakSet.realThis(thisObj, f, cx).js_add(args.length > 0 ? args[0] : Undefined.INSTANCE, cx);
            }
            case 3: {
                return NativeWeakSet.realThis(thisObj, f, cx).js_delete(args.length > 0 ? args[0] : Undefined.INSTANCE);
            }
            case 4: {
                return NativeWeakSet.realThis(thisObj, f, cx).js_has(args.length > 0 ? args[0] : Undefined.INSTANCE);
            }
        }
        throw new IllegalArgumentException("WeakMap.prototype has no method: " + f.getFunctionName());
    }

    private Object js_add(Object key, Context cx) {
        if (!ScriptRuntime.isObject(key)) {
            throw ScriptRuntime.typeError1(cx, "msg.arg.not.object", (Object)ScriptRuntime.typeof(cx, key));
        }
        this.map.put((Scriptable)key, Boolean.TRUE);
        return this;
    }

    private Object js_delete(Object key) {
        if (!ScriptRuntime.isObject(key)) {
            return Boolean.FALSE;
        }
        return this.map.remove(key) != null;
    }

    private Object js_has(Object key) {
        if (!ScriptRuntime.isObject(key)) {
            return Boolean.FALSE;
        }
        return this.map.containsKey(key);
    }

    @Override
    protected void initPrototypeId(int id, Context cx) {
        int arity;
        if (id == 5) {
            this.initPrototypeValue(5, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
            return;
        }
        String fnName = null;
        this.initPrototypeMethod(MAP_TAG, id, switch (id) {
            case 1 -> {
                arity = 0;
                yield "constructor";
            }
            case 2 -> {
                arity = 1;
                yield "add";
            }
            case 3 -> {
                arity = 1;
                yield "delete";
            }
            case 4 -> {
                arity = 1;
                yield "has";
            }
            default -> throw new IllegalArgumentException(String.valueOf(id));
        }, fnName, arity, cx);
    }

    @Override
    protected int findPrototypeId(Symbol k) {
        if (SymbolKey.TO_STRING_TAG.equals(k)) {
            return 5;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "constructor" -> 1;
            case "add" -> 2;
            case "delete" -> 3;
            case "has" -> 4;
            default -> 0;
        };
    }
}

