/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.neoforge.network;

import io.github.kosmx.emotes.arch.network.CommonServerNetworkHandler;
import io.github.kosmx.emotes.arch.network.ConfigTask;
import io.github.kosmx.emotes.arch.network.EmotePacketPayload;
import io.github.kosmx.emotes.arch.network.EmotesMixinConnection;
import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.arch.network.client.ClientNetwork;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.EmoteStreamHelper;
import io.github.kosmx.emotes.common.network.PacketTask;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.executor.EmoteInstance;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import net.minecraft.server.network.ConfigurationTask;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ForgeNetwork {
    @SubscribeEvent
    public static void registerPlay(RegisterPayloadHandlersEvent event) {
        event.registrar("emotecraft").optional().playBidirectional(NetworkPlatformTools.EMOTE_CHANNEL_ID, EmotePacketPayload.EMOTE_CHANNEL_READER, (IPayloadHandler)new DirectionalPayloadHandler((arg, playPayloadContext) -> ClientNetwork.INSTANCE.receiveMessage(arg.unwrapBytes()), (arg, playPayloadContext) -> CommonServerNetworkHandler.instance.receiveMessage(arg.unwrapBytes(), playPayloadContext.player()))).optional().playBidirectional(NetworkPlatformTools.STREAM_CHANNEL_ID, EmotePacketPayload.STREAM_CHANNEL_READER, (IPayloadHandler)new DirectionalPayloadHandler((arg, playPayloadContext) -> {
            try {
                ClientNetwork.INSTANCE.receiveStreamMessage(arg.bytes(), null);
            }
            catch (IOException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
            }
        }, (arg, playPayloadContext) -> CommonServerNetworkHandler.instance.receiveStreamMessage(arg.unwrapBytes(), playPayloadContext.player()))).optional().configurationBidirectional(NetworkPlatformTools.EMOTE_CHANNEL_ID, EmotePacketPayload.EMOTE_CHANNEL_READER, (IPayloadHandler)new DirectionalPayloadHandler((arg, configurationPayloadContext) -> {
            try {
                ClientNetwork.INSTANCE.receiveConfigMessage(arg.bytes(), p -> configurationPayloadContext.listener().send(p));
            }
            catch (IOException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
            }
        }, (arg, configurationPayloadContext) -> {
            try {
                NetData message = new EmotePacket.Builder().build().read(arg.bytes());
                if (message == null || message.purpose != PacketTask.CONFIG) {
                    throw new IOException("Wrong packet type for config task");
                }
                ((EmotesMixinConnection)configurationPayloadContext.connection()).emotecraft$setVersions(message.versions);
                CommonServerNetworkHandler.instance.getServerEmotes(message.versions).forEach(buffer -> new EmoteStreamHelper(){

                    @Override
                    protected int getMaxPacketSize() {
                        return 32751;
                    }

                    @Override
                    protected void sendPlayPacket(ByteBuffer buffer) {
                        configurationPayloadContext.reply(EmotePacketPayload.playPacket(buffer));
                    }

                    @Override
                    protected void sendStreamChunk(ByteBuffer buffer) {
                        configurationPayloadContext.reply(EmotePacketPayload.streamPacket(buffer));
                    }
                });
                configurationPayloadContext.finishCurrentTask(ConfigTask.TYPE);
            }
            catch (IOException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
                configurationPayloadContext.channelHandlerContext().disconnect();
            }
        })).optional().configurationToClient(NetworkPlatformTools.STREAM_CHANNEL_ID, EmotePacketPayload.STREAM_CHANNEL_READER, (arg, configurationPayloadContext) -> {
            try {
                ClientNetwork.INSTANCE.receiveStreamMessage(arg.bytes(), p -> configurationPayloadContext.listener().send(p));
            }
            catch (IOException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
            }
        });
        event.registrar("geyser").optional().playToServer(NetworkPlatformTools.GEYSER_CHANNEL_ID, EmotePacketPayload.GEYSER_CHANNEL_READER, (arg, playPayloadContext) -> CommonServerNetworkHandler.instance.receiveGeyserMessage(playPayloadContext.player(), arg.unwrapBytes()));
    }

    @SubscribeEvent
    public static void registerNetworkConfigTask(RegisterConfigurationTasksEvent event) {
        if (event.getListener().hasChannel(NetworkPlatformTools.EMOTE_CHANNEL_ID) || event.getListener().hasChannel(NetworkPlatformTools.STREAM_CHANNEL_ID)) {
            event.register((ConfigurationTask)new ConfigTask());
        } else {
            EmoteInstance.instance.getLogger().log(Level.FINE, "Client doesn't support emotes, ignoring");
        }
    }
}

