/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network;

import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.arch.mixin.EntityTrackerAccessor;
import io.github.kosmx.emotes.arch.mixin.ServerChunkCacheAccessor;
import io.github.kosmx.emotes.arch.network.AbstractServerNetwork;
import io.github.kosmx.emotes.arch.network.EmotesMixinNetwork;
import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.GeyserEmotePacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.server.network.AbstractServerEmotePlay;
import io.github.kosmx.emotes.server.network.IServerNetworkInstance;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.ChunkSource;
import org.jetbrains.annotations.Nullable;

public final class CommonServerNetworkHandler
extends AbstractServerEmotePlay<Player> {
    public static CommonServerNetworkHandler instance = new CommonServerNetworkHandler();

    private CommonServerNetworkHandler() {
    }

    public static void init() {
    }

    public void receiveMessage(byte[] bytes, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            try {
                this.receiveMessage(bytes, player, (INetworkInstance)CommonServerNetworkHandler.getHandler(serverPlayer.connection));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static IServerNetworkInstance getHandler(ServerGamePacketListenerImpl handler) {
        return ((EmotesMixinNetwork)handler).emotecraft$getServerNetworkInstance();
    }

    public void receiveStreamMessage(byte[] bytes, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.receiveStreamMessage(serverPlayer, CommonServerNetworkHandler.getHandler(serverPlayer.connection), ByteBuffer.wrap(bytes));
        }
    }

    public void receiveStreamMessage(ServerPlayer player, IServerNetworkInstance handler, ByteBuffer buf) {
        try {
            if (((EmotesMixinNetwork)((Object)handler)).emotecraft$getServerNetworkInstance().allowEmoteStreamC2S()) {
                ByteBuffer packet = ((AbstractServerNetwork)((Object)handler)).receiveStreamChunk(buf);
                if (packet != null) {
                    this.receiveMessage(packet.array(), player, (INetworkInstance)handler);
                }
            } else {
                handler.disconnect("Emote stream is disabled on this server");
            }
        }
        catch (IOException e) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    protected UUID getUUIDFromPlayer(Player player) {
        return player.getUUID();
    }

    @Override
    protected Player getPlayerFromUUID(UUID player) {
        return NetworkPlatformTools.getServer().getPlayerList().getPlayer(player);
    }

    @Override
    protected long getRuntimePlayerID(Player player) {
        return player.getId();
    }

    @Override
    protected IServerNetworkInstance getPlayerNetworkInstance(Player sourcePlayer) {
        if (!(sourcePlayer instanceof ServerPlayer)) {
            return null;
        }
        ServerPlayer player = (ServerPlayer)sourcePlayer;
        return ((EmotesMixinNetwork)player.connection).emotecraft$getServerNetworkInstance();
    }

    @Override
    protected void sendForEveryoneElse(GeyserEmotePacket packet, Player player) {
        this.sendForEveryoneElse((NetData)null, packet, player);
    }

    @Override
    protected void sendForEveryoneElse(@Nullable NetData data, @Nullable GeyserEmotePacket geyserPacket, Player player) {
        this.getTrackedPlayers((Entity)player).forEach(target -> {
            if (target != player) {
                try {
                    if (data != null && NetworkPlatformTools.canSendPlay(target, NetworkPlatformTools.EMOTE_CHANNEL_ID.id())) {
                        IServerNetworkInstance playerNetwork = this.getPlayerNetworkInstance((Player)target);
                        playerNetwork.sendMessage(new EmotePacket.Builder(data), null);
                    } else if (geyserPacket != null && NetworkPlatformTools.canSendPlay(target, NetworkPlatformTools.GEYSER_CHANNEL_ID.id())) {
                        IServerNetworkInstance playerNetwork = this.getPlayerNetworkInstance((Player)target);
                        playerNetwork.sendGeyserPacket(ByteBuffer.wrap(geyserPacket.write()));
                    }
                }
                catch (IOException e) {
                    EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
                }
            }
        });
    }

    @Override
    protected void sendForPlayerInRange(NetData data, Player player, UUID target) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sourcePlayer = (ServerPlayer)player;
        try {
            ServerPlayer targetPlayer = sourcePlayer.server.getPlayerList().getPlayer(target);
            if (targetPlayer != null && targetPlayer.getChunkTrackingView().contains(sourcePlayer.chunkPosition())) {
                this.getPlayerNetworkInstance((Player)targetPlayer).sendMessage(new EmotePacket.Builder(data), null);
            }
        }
        catch (IOException e) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    protected void sendForPlayer(NetData data, Player ignore, UUID target) {
        try {
            Player player = this.getPlayerFromUUID(target);
            IServerNetworkInstance playerNetwork = this.getPlayerNetworkInstance(player);
            EmotePacket.Builder packetBuilder = new EmotePacket.Builder(data);
            playerNetwork.sendMessage(packetBuilder, null);
        }
        catch (IOException e) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    private Collection<ServerPlayer> getTrackedPlayers(Entity entity) {
        ChunkSource level = entity.level().getChunkSource();
        if (level instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)level;
            ServerChunkCacheAccessor storage = (ServerChunkCacheAccessor)chunkCache.chunkMap;
            EntityTrackerAccessor tracker = (EntityTrackerAccessor)storage.getTrackedEntity().get(entity.getId());
            if (tracker != null) {
                return tracker.getPlayersTracking().stream().map(ServerPlayerConnection::getPlayer).collect(Collectors.toUnmodifiableSet());
            }
            return Collections.emptyList();
        }
        throw new IllegalArgumentException("server function called on logical client");
    }
}

