/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.ConfigScreen.Components;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigScreen;

public class NumberButtonInfo
extends StringWidget {
    private final ConfigLoaderFromAnnotation.EntryInfo entryInfo;
    private final Component initMessage;
    private final String MOD_ID;
    private long lastTime;
    private int scrollOffset;
    private boolean reverse = false;
    private int effectCooldown = 0;

    public NumberButtonInfo(String MOD_ID, int width, int height, Component message, Font font, ConfigLoaderFromAnnotation.EntryInfo info) {
        super(width, height, message, font);
        this.entryInfo = info;
        this.initMessage = message;
        this.MOD_ID = MOD_ID;
        this.lastTime = System.currentTimeMillis();
        this.scrollOffset = 0;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Font font = Minecraft.getInstance().font;
        String scrollingText = this.trimTextWithEllipsis(this.initMessage.getString(), this.width, font);
        MutableComponent valueStatusIndicator = Component.literal((String)scrollingText);
        if (this.isChanging()) {
            valueStatusIndicator = Component.literal((String)scrollingText).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.YELLOW});
        }
        this.setMessage((Component)valueStatusIndicator);
        if (this.isMouseOver(mouseX, mouseY) && !Objects.equals(this.entryInfo.name, ConfigScreen.currentInfo)) {
            ConfigScreen.infoTab_Title.setMessage((Component)Component.literal((String)this.entryInfo.humanizeName).withStyle(ChatFormatting.BOLD));
            MutableComponent info = Component.translatable((String)(this.MOD_ID + ".config." + this.entryInfo.name + ".tooltip"));
            if (this.entryInfo.require_restart) {
                info.append((Component)Component.literal((String)"\n\n").append((Component)Component.translatable((String)(this.MOD_ID + ".config.require_restart")).withStyle(ChatFormatting.GOLD)));
            }
            ConfigScreen.infoTab_Info.setMessage((Component)info);
            ConfigScreen.infoTab.arrangeElements();
            ConfigScreen.currentInfo = this.entryInfo.name;
        }
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
    }

    private boolean isChanging() {
        Object value;
        try {
            value = this.entryInfo.targetField.get(null);
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("[backpack] Something went wrong with the Option button...");
            e.printStackTrace();
            return false;
        }
        Object lastValue = ConfigScreen.CONFIG_VALUES.get(this.entryInfo.name);
        return !value.equals(lastValue);
    }

    private String trimTextWithEllipsis(String text, int maxWidth, Font textRenderer) {
        if (textRenderer.width(text) <= maxWidth) {
            return text;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTime > 150L) {
            if (this.effectCooldown > 0) {
                --this.effectCooldown;
                String scrollingText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
                return textRenderer.plainSubstrByWidth(scrollingText, maxWidth - textRenderer.width("...")) + "...";
            }
            this.scrollOffset = !this.reverse ? (this.scrollOffset + 1) % text.length() : (this.scrollOffset - 1) % text.length();
            String checkText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
            if (textRenderer.width(checkText) + 6 < maxWidth || this.scrollOffset < 1) {
                this.reverse = !this.reverse;
                this.effectCooldown = 90;
            }
            this.lastTime = currentTime;
        }
        String scrollingText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
        return textRenderer.plainSubstrByWidth(scrollingText, maxWidth - textRenderer.width("...")) + "...";
    }

    private String getScrollingText(String text, int scrollOffset, int maxWidth, Font textRenderer) {
        String visiblePart;
        if (scrollOffset < 0) {
            scrollOffset = 0;
        }
        if (scrollOffset > text.length()) {
            scrollOffset = text.length();
        }
        if (textRenderer.width(visiblePart = text.substring(scrollOffset)) > maxWidth) {
            visiblePart = textRenderer.plainSubstrByWidth(visiblePart, maxWidth);
        }
        return visiblePart;
    }
}

